% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/findPattern.R
\name{findPattern}
\alias{findPattern}
\title{Find specific IBD patterns}
\usage{
findPattern(sims, pattern)
}
\arguments{
\item{sims}{A \code{genomeSim} object, or a list of such. Typically made by
\code{\link[=ibdsim]{ibdsim()}}.}

\item{pattern}{A list of two vectors names \code{carriers} and \code{noncarriers}.}
}
\value{
A matrix (if \code{sims} is a single \code{genomeSim} object), or a list of
matrices.
}
\description{
Find segments satisfying a particular pattern of IBD sharing, in a list of
IBD simulations
}
\details{
For each simulation, this function extracts the subset of rows satisfying the
allele sharing specified by \code{pattern}. That is, segments where some allele
occur in all of \code{pattern$carriers}, but in none of \code{pattern$noncarriers}.
}
\examples{
x = nuclearPed(3)
s = ibdsim(x, N = 1, map = uniformMap(M = 1), seed = 1729)
s1 = s[[1]]

# Segments where some allele is shared by 3 and 4, but not 5
pattern = list(carriers = 3:4, noncarriers = 5)
findPattern(s1, pattern)

# Visual confirmation:
haploDraw(x, s1, margin = c(5,3,3,3))

}
