% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{cran_history}
\alias{cran_history}
\title{History of the Number of Available CRAN Packages}
\format{
Data frame with 25 rows and 10 variables. The first column (\code{Country})
indicates the name of the country, the other columns indicate protein
consumption from nine sources sources in unknown units.
}
\usage{
cran_history
}
\description{
Table with the number of packages available on CRAN and the current R version
for historic dates back to 21 June 2001.
}
\details{
Data on the number of packages on CRAN between 2001-06-21 and 2014-04-13
is obtained from
\href{https://www.rdocumentation.org/packages/Ecdat/versions/0.3-9/topics/CRANpackages}{\code{CRANpackages}}
from the package \href{https://cran.r-project.org/package=Ecdat}{\code{Ecdat}}.
This data was collected by John Fox and Spencer Graves.
Intervals between data points are irregularly spaced. These data are
marked with \verb{John Fox} or \verb{Spencer Graves} in the column \code{source}.
They are licenced under GPL-2/GPL-3.

Newer data was obtained using the functions \code{\link[=n_available_packages]{n_available_packages()}} and
\code{\link[=available_r_version]{available_r_version()}} which extract the information from CRAN snapshots
on MRAN. One data point per quarter is available starting on 2014-10-01.
These data are marked with \code{MRAN} in the column \code{source}.
}
\examples{
library(ggplot2)
ggplot(cran_history, aes(x = date, y = n_packages)) +
  geom_point()

}
\keyword{datasets}
