% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/voronoi.R
\name{voronoi_diagram}
\alias{voronoi_diagram}
\title{Create a Voronoi Diagram for a Clustering}
\usage{
voronoi_diagram(
  cluster,
  x,
  y,
  data = NULL,
  show_data = !is.null(data),
  legend = TRUE,
  point_size = 2,
  linewidth = 0.7
)
}
\arguments{
\item{cluster}{an object containing the result of a clustering, e.g.,
created by \code{\link[=kmeans]{kmeans()}}. It must contain the fields \code{cluster} and
\code{centers}.}

\item{x, y}{character giving the names of the variables to be plotted
on the x- and y-axis.}

\item{data}{The data that has been used to create the clustering. If this
is provided, the extension of the plot is adapted to the data and the
data points are plotted unless this is suppressed by specifying
\code{show_data = FALSE}.}

\item{show_data}{should the data points be plotted? This is \code{TRUE} by default
if \code{data} is given.}

\item{legend}{should a colour legend for the clusters be plotted?}

\item{point_size}{numeric indicating the size of the data points and the
cluster centres.}

\item{linewidth}{numeric indicating the width of the lines that separate
the areas for the clusters. Set to 0 to show no lines at all.}
}
\description{
Create a Voronoi diagram for a given clustering object.
}
\details{
The function uses the \code{deldir} package to create the polygons for the
Voronoi diagram. The code has been inspired by \code{ggvoronoi}, which can
handle more complex situations.
}
\examples{
\donttest{
cluster <- kmeans(iris[, 1:4], centers = 3)
voronoi_diagram(cluster, "Sepal.Length", "Sepal.Width", iris)
}

}
\references{
Garrett et al., \emph{ggvoronoi: Voronoi Diagrams and Heatmaps with ggplot2},
Journal of Open Source Software 3(32) (2018) 1096,
\doi{10.21105/joss.01096}
}
