% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ifcb_annotate_batch.R
\name{ifcb_annotate_batch}
\alias{ifcb_annotate_batch}
\title{Annotate IFCB Images with Specified Class}
\usage{
ifcb_annotate_batch(
  png_images,
  class,
  manual_folder,
  adc_files,
  class2use_file,
  manual_output = NULL,
  manual_recursive = FALSE,
  unclassified_id = 1,
  do_compression = TRUE,
  adc_folder = deprecated()
)
}
\arguments{
\item{png_images}{A character vector containing the names of the PNG images to be annotated in the format DYYYYMMDDTHHMMSS_IFCBXXX_ZZZZZ.png, where XXX represent the IFCB number and ZZZZZ the roi number.}

\item{class}{A character string or integer specifying the class name or class2use index to annotate the images with. If a string is provided, it is matched against the available classes in \code{class2use_file}.}

\item{manual_folder}{A character string specifying the path to the folder containing the manual \code{.mat} classlist files.}

\item{adc_files}{A character string specifying the path to the folder containing the raw data, organized in subfolders by year (YYYY) and date (DYYYYMMDD), or a vector with full paths to the \code{.adc} files. Each ADC file is used to determine the number of regions of interest (ROIs) for each sample when creating new manual \code{.mat} files.}

\item{class2use_file}{A character string specifying the path to the \code{.mat} file containing class names and corresponding indices.}

\item{manual_output}{A character string specifying the path to the folder where updated or newly created \code{.mat} classlist files will be saved. If not provided, the \code{manual_folder} path will be used by default.}

\item{manual_recursive}{A logical value indicating whether to search recursively within \code{manual_folder} for \code{.mat} files. Default is \code{FALSE}.}

\item{unclassified_id}{An integer specifying the class ID to use for unclassified regions of interest (ROIs) when creating new manual \code{.mat} files. Default is \code{1}.}

\item{do_compression}{A logical value indicating whether to compress the .mat file. Default is TRUE.}

\item{adc_folder}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}

Use \code{adc_files} instead.}
}
\value{
The function does not return a value. It creates or updates \code{.mat} files in the \code{manual_folder} to
reflect the specified annotations.
}
\description{
This function creates or updates manual \code{.mat} classlist files with a user specified class in batch,
based on input vector of IFCB image names.
These \code{.mat} files can be used with the code in the \code{ifcb-analysis} repository (Sosik and Olson 2007).
}
\details{
Python must be installed to use this function. The required python packages can be installed in a virtual environment using \code{ifcb_py_install()}.

If an image belongs to a sample that already has a corresponding manual \code{.mat} file,
the function updates the class IDs for the specified regions of interest (ROIs) in that file.
If no manual file exists for the sample, the function creates a new one based on the sample's ADC data,
assigning unclassified IDs to all ROIs initially, then applying the specified class to the relevant ROIs.

The class parameter can be provided as either a string (class name) or an integer (class index).
If a string is provided, the function will attempt to match it to one of the available
classes in \code{class2use_file}. If no match is found, an error is thrown.

The function assumes that the ADC files are organized in subfolders by year (YYYY) and date (DYYYYMMDD) within \code{adc_files}.
}
\examples{
\dontrun{
# Initialize a python session if not already set up
ifcb_py_install()

# Annotate two png images with class "Nodularia_spumigena" and update or create manual files
ifcb_annotate_batch(
  png_images = c("D20230812T162908_IFCB134_01399.png",
                 "D20230714T102127_IFCB134_00069.png"),
  class = "Nodularia_spumigena",
  manual_folder = "path/to/manual",
  adc_files = "path/to/adc",
  class2use_file = "path/to/class2use.mat"
)
}

}
\references{
Sosik, H. M. and Olson, R. J. (2007), Automated taxonomic classification of phytoplankton sampled with imaging-in-flow cytometry. Limnol. Oceanogr: Methods 5, 204–216.
}
\seealso{
\code{\link{ifcb_correct_annotation}}, \code{\link{ifcb_create_manual_file}}
}
