% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/decomposition.R
\name{decompose}
\alias{decompose}
\alias{plot.inzdecomp}
\title{Decompose a time series object}
\usage{
decompose(
  obj,
  multiplicative = FALSE,
  t = 10,
  model.lim = NULL,
  data.name = NULL,
  ...
)

\method{plot}{inzdecomp}(
  x,
  recompose.progress = c(0, 0),
  recompose = any(recompose.progress > 0),
  ylab = x$currVar,
  xlab = "Date",
  title = NULL,
  xlim = c(NA, NA),
  colour = c("#1B9E46", "#45a8ff", "orangered"),
  ...
)
}
\arguments{
\item{obj}{an iNZightTS object}

\item{multiplicative}{fit a multiplicative time series model?}

\item{t}{the smoothing parameter}

\item{model.lim}{limits for the time series model}

\item{data.name}{the name of the data}

\item{...}{additional arguments (ignored)}

\item{x}{an inzdecomp object (from decompose(ts))}

\item{recompose.progress}{if recompose is \code{TRUE}, this shows how
much to show (for animation!). Length 2 numeric: the first
is 0 for seasonal, and 1 for residual; second component is
how many observations have been recomposed so far}

\item{recompose}{logical as to whether the recomposition is shown or not}

\item{ylab}{the label for the y axis}

\item{xlab}{the label for the x axis}

\item{title}{the title for the plot}

\item{xlim}{the x axis limits}

\item{colour}{vector of three colours for trend, seasonal, and residuals, respectively}
}
\value{
an \code{inzdecomp} object (this is the original
        object with an additional \code{decompVars} component)

Invisibly returns the original decomposition object. Mainly called
        to plot the decomposition.
}
\description{
Decompose a time series object
}
\section{Methods (by generic)}{
\itemize{
\item \code{plot}: Plot a time series decomposition
}}

\examples{
t <- iNZightTS(visitorsQ)
decomp.ts <- decompose(t, data.name = "Visitors")
plot(decomp.ts)

}
\references{
R. B. Cleveland, W. S. Cleveland, J.E. McRae, and I. Terpenning (1990)
STL: A Seasonal-Trend Decomposition Procedure Based on Loess.
Journal of Official Statistics, 6, 3iV73.
}
