% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/barplot.R
\name{barplotMR}
\alias{barplotMR}
\alias{barplotMR.mrocalc}
\alias{barplotMR.bymrocalc}
\alias{barplotMR.between}
\alias{barplotMR.b2}
\title{Multiple response barplot}
\usage{
barplotMR(obj, ...)

\method{barplotMR}{mrocalc}(obj, ...)

\method{barplotMR}{bymrocalc}(obj, g1.level = NULL, g2.level = "_MULTI", ...)

\method{barplotMR}{between}(obj, ...)

\method{barplotMR}{b2}(obj, g1.level = NULL, ...)
}
\arguments{
\item{obj}{an \code{mrocalc} object (from \code{mroPara()})}

\item{...}{additional parameters, currently not used}

\item{g1.level}{vector of subset variable 1 levels to show}

\item{g2.level}{vector of subset variable 2 levels to show}
}
\description{
Draws a barplot of a multiple response object (MRO), showing response rates for
each option along with confidence intervals and comparison intervals.
}
\section{Methods (by class)}{
\itemize{
\item \code{mrocalc}: method for class \code{mrocalc}

\item \code{bymrocalc}: method for class \code{bymrocalc}

\item \code{between}: method for class \code{between}

\item \code{b2}: method for class \code{b2}
}}

\examples{
if (requireNamespace("iNZightPlots")) {
    mr <- iNZightMR(online ~ onlinegame + onlinevideo + onlinemusic,
        data = census.at.school.5000)
    barplotMR(mroPara(mr))

    barplotMR(byMRO(mr, ~gender, mroPara))
}
}
\author{
Junjie Zheng
}
