% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MainFun.r
\name{ggiNEXTbeta3D}
\alias{ggiNEXTbeta3D}
\title{ggplot2 extension for the iNEXTbeta3D object}
\usage{
ggiNEXTbeta3D(output, type = "B")
}
\arguments{
\item{output}{output from the function \code{iNEXTbeta3D}.}

\item{type}{(argument only for \code{base = "coverage"}),\cr
\code{type = 'B'} for plotting the rarefaction and extrapolation sampling curves for gamma, alpha, and beta diversity;  \cr
\code{type = 'D'} for plotting the rarefaction and extrapolation sampling curves for four dissimilarity indices.\cr
Skip the argument for plotting size-based rarefaction and extrapolation sampling curves for gamma and alpha diversity.}
}
\value{
a figure for gamma, alpha, and beta diversity, or a figure for four dissimilarity indices for \code{base = "coverage"}; 
or a figure for gamma and alpha diversity when \code{base = "size"}.\cr
}
\description{
\code{ggiNEXTbeta3D} is an \code{ggplot2} extension for the \code{iNEXTbeta3D} 
object to plot sample-size- and coverage-based rarefaction/extrapolation curves.
}
\examples{
\donttest{
## (Graphic Display) Taxonomic diversity for abundance data
# Coverage-based rarefaction and extrapolation sampling curves 
data(Brazil_rainforests)
output_TDc_abun = iNEXTbeta3D(data = Brazil_rainforests, diversity = 'TD', 
                              datatype = 'abundance', base = "coverage", nboot = 10)

ggiNEXTbeta3D(output_TDc_abun, type = 'B')
ggiNEXTbeta3D(output_TDc_abun, type = 'D')
}

# Size-based rarefaction and extrapolation sampling curves 
data(Brazil_rainforests)
output_TDs_abun = iNEXTbeta3D(data = Brazil_rainforests, diversity = 'TD', 
                              datatype = 'abundance', base = "size", nboot = 10)

ggiNEXTbeta3D(output_TDs_abun)

\donttest{
## (Graphic Display) Taxonomic diversity for incidence data
# Coverage-based rarefaction and extrapolation sampling curves 
data(Second_growth_forests)
output_TDc_inci = iNEXTbeta3D(data = Second_growth_forests, diversity = 'TD', 
                              datatype = 'incidence_raw', base = "coverage", nboot = 10)

ggiNEXTbeta3D(output_TDc_inci, type = 'B')
ggiNEXTbeta3D(output_TDc_inci, type = 'D')
}

# Size-based rarefaction and extrapolation sampling curves 
data(Second_growth_forests)
output_TDs_inci = iNEXTbeta3D(data = Second_growth_forests, diversity = 'TD', 
                              datatype = 'incidence_raw', base = "size", nboot = 10)

ggiNEXTbeta3D(output_TDs_inci)

\donttest{
## (Graphic Display) Phylogenetic diversity for abundance data
# Coverage-based rarefaction and extrapolation sampling curves 
data(Brazil_rainforests)
data(Brazil_tree)
output_PDc_abun = iNEXTbeta3D(data = Brazil_rainforests, diversity = 'PD', 
                              datatype = 'abundance', base = "coverage", nboot = 10, 
                              PDtree = Brazil_tree, PDreftime = NULL, PDtype = 'meanPD')

ggiNEXTbeta3D(output_PDc_abun, type = 'B')
ggiNEXTbeta3D(output_PDc_abun, type = 'D')


# Size-based rarefaction and extrapolation sampling curves 
data(Brazil_rainforests)
data(Brazil_tree)
output_PDs_abun = iNEXTbeta3D(data = Brazil_rainforests, diversity = 'PD', 
                              datatype = 'abundance', base = "size", nboot = 10, 
                              PDtree = Brazil_tree, PDreftime = NULL, PDtype = 'meanPD')

ggiNEXTbeta3D(output_PDs_abun)


## (Graphic Display) Functional diversity for abundance data when all threshold levels 
## from 0 to 1 are considered
# Coverage-based rarefaction and extrapolation sampling curves 
data(Brazil_rainforests)
data(Brazil_distM)
output_FDc_abun = iNEXTbeta3D(data = Brazil_rainforests, diversity = 'FD', 
                              datatype = 'abundance', base = "coverage", nboot = 10, 
                              FDdistM = Brazil_distM, FDtype = 'AUC', FDcut_number = 30)

ggiNEXTbeta3D(output_FDc_abun, type = 'B')
ggiNEXTbeta3D(output_FDc_abun, type = 'D')


# Size-based rarefaction and extrapolation sampling curves 
data(Brazil_rainforests)
data(Brazil_distM)
output_FDs_abun = iNEXTbeta3D(data = Brazil_rainforests, diversity = 'FD', 
                              datatype = 'abundance', base = "size", nboot = 10, 
                              FDdistM = Brazil_distM, FDtype = 'AUC', FDcut_number = 30)

ggiNEXTbeta3D(output_FDs_abun)
}


}
