/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.hups;

import umontreal.iro.lecuyer.hups.PointSet;
import umontreal.iro.lecuyer.hups.PointSetIterator;
import umontreal.iro.lecuyer.rng.RandomStream;
import umontreal.iro.lecuyer.util.PrintfFormat;

public class PaddedPointSet
extends PointSet {
    protected int curPointSets = 0;
    protected int maxPointSets;
    protected PointSet[] pointSet;
    protected int[] startDim;
    protected int[][] permutation;

    public PaddedPointSet(int maxPointSets) {
        this.maxPointSets = maxPointSets;
        this.pointSet = new PointSet[maxPointSets];
        this.startDim = new int[maxPointSets];
        this.permutation = new int[maxPointSets][];
    }

    public void padPointSet(PointSet P) {
        if (this.curPointSets == this.maxPointSets) {
            throw new IllegalArgumentException("Cannot pad more, increase maxPointSets parameter");
        }
        if (this.dim == Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Cannot pad more, dimension already infinite");
        }
        if (this.curPointSets > 0 && this.numPoints != P.getNumPoints()) {
            throw new IllegalArgumentException("Padded points must have same number of points");
        }
        if (this.curPointSets == 0) {
            this.numPoints = P.getNumPoints();
        }
        this.dim = P.getDimension() == Integer.MAX_VALUE ? Integer.MAX_VALUE : (this.dim += P.getDimension());
        this.pointSet[this.curPointSets] = P;
        this.startDim[this.curPointSets] = this.dim;
        ++this.curPointSets;
    }

    public void padPointSetPermute(PointSet P) {
        if (this.curPointSets == 0) {
            this.numPoints = P.getNumPoints();
        }
        if (this.numPoints == Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Cannot generate infinite permutation");
        }
        this.permutation[this.curPointSets] = new int[this.numPoints];
        for (int i = 0; i < this.numPoints; ++i) {
            this.permutation[this.curPointSets][i] = i;
        }
        this.padPointSet(P);
    }

    public double getCoordinate(int i, int j) {
        int set = 0;
        if (j >= this.dim) {
            throw new IllegalArgumentException("Not enough dimensions");
        }
        while (j >= this.startDim[set]) {
            ++set;
        }
        if (this.permutation[set] != null) {
            i = this.permutation[set][i];
        }
        if (set != 0) {
            j -= this.startDim[set - 1];
        }
        return this.pointSet[set].getCoordinate(i, j);
    }

    public void unrandomize() {
        for (int set = 0; set < this.curPointSets; ++set) {
            if (this.permutation[set] == null) continue;
            for (int i = 0; i < this.numPoints; ++i) {
                this.permutation[set][i] = i;
            }
        }
    }

    public void randomize(RandomStream stream) {
        super.randomize(stream);
        for (int set = 0; set < this.curPointSets; ++set) {
            if (this.permutation[set] == null) continue;
            for (int i = 0; i < this.numPoints - 1; ++i) {
                int u = stream.nextInt(0, this.numPoints - i - 1);
                int h = this.permutation[set][i];
                this.permutation[set][i] = this.permutation[set][i + u];
                this.permutation[set][i + u] = h;
            }
        }
    }

    public PointSetIterator iterator() {
        return new PaddedIterator();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("Padded point set" + PrintfFormat.NEWLINE);
        sb.append("Maximal number of point sets: " + this.maxPointSets + PrintfFormat.NEWLINE);
        sb.append("Current number of point sets: " + this.curPointSets + PrintfFormat.NEWLINE);
        sb.append("Number of points: " + this.numPoints + PrintfFormat.NEWLINE);
        for (int i = 0; i < this.curPointSets; ++i) {
            if (i != 0) {
                sb.append(PrintfFormat.NEWLINE);
            }
            if (this.permutation[i] == null) {
                sb.append("Point set ");
            } else {
                sb.append("Permuted point set ");
            }
            sb.append(i + " information: {" + PrintfFormat.NEWLINE + this.pointSet[i].toString() + PrintfFormat.NEWLINE + "}");
        }
        return sb.toString();
    }

    private class PaddedIterator
    extends PointSet.DefaultPointSetIterator {
        private PointSetIterator[] pointSetIterators;
        private int currentSet;
        private double[] temp;

        public PaddedIterator() {
            super(PaddedPointSet.this);
            this.currentSet = 0;
            this.pointSetIterators = new PointSetIterator[PaddedPointSet.this.curPointSets];
            int maxdim = 0;
            for (int i = 0; i < PaddedPointSet.this.curPointSets; ++i) {
                this.pointSetIterators[i] = PaddedPointSet.this.pointSet[i].iterator();
                if (PaddedPointSet.this.pointSet[i].getDimension() > maxdim) {
                    maxdim = PaddedPointSet.this.pointSet[i].getDimension();
                }
                if (PaddedPointSet.this.permutation[i] == null) continue;
                this.pointSetIterators[i].setCurPointIndex(PaddedPointSet.this.permutation[i][0]);
            }
            this.temp = maxdim == Integer.MAX_VALUE ? new double[16] : new double[maxdim];
        }

        public void setCurCoordIndex(int j) {
            int set = 0;
            if (j >= PaddedPointSet.this.dim) {
                throw new IllegalArgumentException("Not enough dimensions");
            }
            while (j >= PaddedPointSet.this.startDim[set]) {
                ++set;
            }
            this.currentSet = set;
            this.pointSetIterators[this.currentSet].setCurCoordIndex(set == 0 ? j : j - PaddedPointSet.this.startDim[set - 1]);
            for (set = this.currentSet + 1; set < this.pointSetIterators.length; ++set) {
                this.pointSetIterators[set].resetCurCoordIndex();
            }
            this.curCoordIndex = j;
        }

        public void resetCurCoordIndex() {
            this.currentSet = 0;
            for (int i = 0; i < this.pointSetIterators.length; ++i) {
                this.pointSetIterators[i].resetCurCoordIndex();
            }
            this.curCoordIndex = 0;
        }

        public double nextCoordinate() {
            if (this.curPointIndex >= PaddedPointSet.this.numPoints || this.curCoordIndex >= PaddedPointSet.this.dim) {
                this.outOfBounds();
            }
            if (this.curCoordIndex >= PaddedPointSet.this.startDim[this.currentSet]) {
                ++this.currentSet;
            }
            double coord = this.pointSetIterators[this.currentSet].nextCoordinate();
            ++this.curCoordIndex;
            return coord;
        }

        public void nextCoordinates(double[] p, int d) {
            if (this.curPointIndex >= PaddedPointSet.this.numPoints || d > PaddedPointSet.this.dim) {
                this.outOfBounds();
            }
            int i = 0;
            while (i < d) {
                int dimen = PaddedPointSet.this.pointSet[this.currentSet].getDimension();
                dimen = dimen == Integer.MAX_VALUE ? d - i : (dimen -= this.pointSetIterators[this.currentSet].getCurCoordIndex());
                this.pointSetIterators[this.currentSet].nextCoordinates(this.temp, dimen);
                System.arraycopy(this.temp, 0, p, i, dimen);
                this.curCoordIndex += dimen;
                if ((i += dimen) >= d) continue;
                ++this.currentSet;
            }
        }

        public void setCurPointIndex(int i) {
            for (int it = 0; it < this.pointSetIterators.length; ++it) {
                this.pointSetIterators[it].setCurPointIndex(PaddedPointSet.this.permutation[it] == null ? i : PaddedPointSet.this.permutation[it][i]);
            }
            this.curPointIndex = i;
            this.curCoordIndex = 0;
            this.currentSet = 0;
        }

        public void resetCurPointIndex() {
            for (int i = 0; i < this.pointSetIterators.length; ++i) {
                if (PaddedPointSet.this.permutation[i] == null) {
                    this.pointSetIterators[i].resetCurPointIndex();
                    continue;
                }
                this.pointSetIterators[i].setCurPointIndex(PaddedPointSet.this.permutation[i][0]);
            }
            this.curPointIndex = 0;
            this.curCoordIndex = 0;
            this.currentSet = 0;
        }

        public int resetToNextPoint() {
            for (int i = 0; i < this.pointSetIterators.length; ++i) {
                if (PaddedPointSet.this.permutation[i] == null) {
                    this.pointSetIterators[i].resetToNextPoint();
                    continue;
                }
                this.pointSetIterators[i].setCurPointIndex(PaddedPointSet.this.permutation[i][this.curPointIndex + 1]);
            }
            this.currentSet = 0;
            this.curCoordIndex = 0;
            return ++this.curPointIndex;
        }

        public String formatState() {
            return super.formatState() + PrintfFormat.NEWLINE + "Current padded set: " + this.currentSet;
        }
    }
}

