% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gm_isorank.R
\name{graph_match_IsoRank}
\alias{graph_match_IsoRank}
\title{Spectral Graph Matching Methods: IsoRank Algorithm}
\usage{
graph_match_IsoRank(
  A,
  B,
  seeds = NULL,
  similarity,
  max_iter = 50,
  method = "greedy"
)
}
\arguments{
\item{A}{A matrix, 'igraph' object, or list of either.}

\item{B}{A matrix, 'igraph' object, or list of either.}

\item{seeds}{A vector of integers or logicals, a matrix or a data frame. If
the seed pairs have the same indices in both graphs then seeds can be a
vector. If not, seeds must be  a matrix
or a data frame, with the first column being the indices of \eqn{G_1} and
the second column being the corresponding indices of \eqn{G_2}.}

\item{similarity}{A matrix. An \code{n-by-n} matrix containing vertex similarities.}

\item{max_iter}{A number. Maximum number of replacing matches equals to
max_iter times number of total vertices of \eqn{G_1}.}

\item{method}{A character. Choice of method to extract mapping from score matrix,
including greedy method and the Hungarian algorithm.}
}
\value{
\code{graph_match_IsoRank} returns a list of graph matching
  results, including the graph matching formula, a data frame containing the
  matching correspondence between \eqn{G_1} and \eqn{G_2} named \code{corr_A}
  and \code{corr_B} and seeds. If choose the greedy method to extract mapping,
  the order of nodes getting matched will also be returned.
}
\description{
Spectral Graph Matching Methods: IsoRank Algorithm
}
\examples{
cgnp_pair <- sample_correlated_gnp_pair(n = 10, corr =  0.3, p =  0.5)
g1 <- cgnp_pair$graph1
g2 <- cgnp_pair$graph2
# match G_1 & G_2 using IsoRank algorithm
startm <- matrix(0, 10, 10)
diag(startm)[1:4] <- 1
GM_IsoRank <- graph_match_IsoRank(g1, g2, similarity = startm, method = "greedy")

}
\references{
R. Singh, J. Xu, B. Berger (2008), \emph{Global alignment of
multiple protein interaction networks with application to functional
orthology detection}. Proc Natl Acad Sci. USA, pages 12763-12768.
}
