% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/piplot.R
\name{piplot}
\alias{piplot}
\title{Generates a probability inclusion plot based on an iClusterVB object}
\usage{
piplot(
  fit,
  plot_grid = TRUE,
  ylab = "Probability of Inclusion",
  title = NULL,
  ...
)
}
\arguments{
\item{fit}{A fitted iClusterVB object.}

\item{plot_grid}{LOGICAL. Whether to use the \code{\link[cowplot]{plot_grid}}
function from the \bold{cowplot} package. The default is TRUE.}

\item{ylab}{The y-axis label. The default is "Probability of Inclusion".}

\item{title}{The title of the plots. It can be a character vector or a single
value. The default output is "View 1 - Distribution 1", ..., "View R -
Distribution R".}

\item{...}{Additional arguments to add to the
\code{\link[cowplot]{plot_grid}} function.}
}
\value{
Returns a probability inclusion plot or plots.
}
\description{
Generates a probability inclusion plot based on an iClusterVB object
}
\examples{
# Setting up the data
dat1 <- list(
  gauss_1 = sim_data$continuous1_data[c(1:20, 61:80, 121:140, 181:200), 1:75],
  gauss_2 = sim_data$continuous2_data[c(1:20, 61:80, 121:140, 181:200), 1:75],
  poisson_1 = sim_data$count_data[c(1:20, 61:80, 121:140, 181:200), 1:75],
  multinomial_1 = sim_data$binary_data[c(1:20, 61:80, 121:140, 181:200), 1:75]
)

# Recoding `0`s to `2`s
dat1$multinomial_1[dat1$multinomial_1 == 0] <- 2

dist <- c(
  "gaussian", "gaussian",
  "poisson", "multinomial"
)

fit_iClusterVB <- iClusterVB(
  mydata = dat1,
  dist = dist,
  K = 4,
  initial_method = "VarSelLCM",
  VS_method = 1,
  max_iter = 25
)

piplot(fit_iClusterVB)

}
