% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_break_down_uncertainty.R
\name{plot.break_down_uncertainty}
\alias{plot.break_down_uncertainty}
\title{Plot Generic for Break Down Uncertainty Objects}
\usage{
\method{plot}{break_down_uncertainty}(x, ...,
  vcolors = DALEX::theme_drwhy_colors_break_down())
}
\arguments{
\item{x}{the model model of `break_down_uncertainty` class.}

\item{...}{other parameters.}

\item{vcolors}{named vector with colors.}
}
\value{
a `ggplot2` object.
}
\description{
Plot Generic for Break Down Uncertainty Objects
}
\examples{
library("DALEX")
library("iBreakDown")
# Toy examples, because CRAN angels ask for them
titanic <- na.omit(titanic)
set.seed(1313)
titanic_small <- titanic[sample(1:nrow(titanic), 500), c(1,2,6,9)]
model_titanic_glm <- glm(survived == "yes" ~ gender + age + fare,
                       data = titanic_small, family = "binomial")
explain_titanic_glm <- explain(model_titanic_glm,
                           data = titanic_small[,-9],
                           y = titanic_small$survived == "yes")
bd_rf <- local_attributions_uncertainty(explain_titanic_glm, titanic_small[1, ],
                           path = c(3,2,1))
bd_rf
plot(bd_rf)

\donttest{
## Not run:
library("randomForest")
set.seed(1313)

model <- randomForest(status ~ . , data = HR)
new_observation <- HR_test[1,]

explainer_rf <- explain(model,
                        data = HR[1:1000,1:5],
                        y = HR$status[1:1000])

bd_rf <- local_attributions_uncertainty(explainer_rf,
                           new_observation,
                           path = c(3,2,4,1,5))
bd_rf
plot(bd_rf)

# example for regression - apartment prices
# here we do not have intreactions
model <- randomForest(m2.price ~ . , data = apartments)
explainer_rf <- explain(model,
                        data = apartments_test[1:1000,2:6],
                        y = apartments_test$m2.price[1:1000])

bd_rf <- local_attributions_uncertainty(explainer_rf,
                                     apartments_test[1,],
                                     path = c("floor", "no.rooms", "district",
                                         "construction.year", "surface"))
bd_rf
plot(bd_rf)
}
}
\references{
Predictive Models: Visual Exploration, Explanation and Debugging \url{https://pbiecek.github.io/PM_VEE}
}
