% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eff.stg1.R
\name{eff.stg1}
\alias{eff.stg1}
\title{Generates efficacy outcomes for stage 1}
\usage{
eff.stg1(dose, dose.tox, p1, p2, K, coh.size, m, v, nbb = 100)
}
\arguments{
\item{dose}{number of doses to be tested (scalar)}

\item{dose.tox}{vector of true toxicities for each dose. Values range from 0 - 1.}

\item{p1}{toxicity under null (unsafe DLT rate). Values range from 0 - 1.}

\item{p2}{toxicity under alternative (safe DLT rate). Values range from 0 - 1; p1 > p2}

\item{K}{threshold for LR. Takes integer values: 1,2,...(recommended K=2)}

\item{coh.size}{cohort size (number of patients) per dose (Stage 1)}

\item{m}{vector of mean efficacies per dose. Values range from 0 - 100. 
(e.g, T cell persistence - values b/w 5 and 80 per cent)}

\item{v}{vector of efficacy variances per dose. Values range from 0 - 1. (e.g., 0.01)}

\item{nbb}{binomial parameter (default = 100 cells per patient)}
}
\value{
List of efficacy outcomes for subject enrolled during stage 1 (dose-escalation)
\itemize{
\item Y.safe - vector of efficacy outcomes for each subject enrolled on an acceptably toxic dose
\item d.safe - vector of dose allocation for each subject enrolled on an acceptably toxic dose
\item tox.safe - number of dose-limiting toxicities for each safe dose level
\item Y.alloc - vector of efficacy outcomes for all subjects enrolled on all doses (safe and unsafe)
\item d.alloc - vector of dose allocation for all subjects enrolled on all doses (safe and unsafe)
}
}
\description{
Function \code{eff.stg1()} uses a beta-binomial distribution to generate 
outcomes (Ys) corresponding to acceptable dose assignments from stage 1.
}
\examples{
# Number of pre-specified dose levels
dose <- 5
# Vector of true toxicities associated with each dose
dose.tox <- c(0.05, 0.10, 0.20, 0.35, 0.45)       
# Acceptable (p_yes) and unacceptable (p_no) DLT rates used for establishing safety
p_no <- 0.40                                     
p_yes <- 0.15    

# Likelihood-ratio (LR) threshold
K <- 2                                          

# Cohort size used in stage 1
coh.size <- 3 

# Vector of true mean efficacies per dose (here mean percent persistence per dose)
m <- c(5, 15, 40, 65, 80)   # MUST BE THE SAME LENGTH AS dose.tox                  

# Efficacy(equal) variance per dose
v <- rep(0.01, 5) 

# Total sample size (stages 1&2)                            
N <- 25                                        

# Stopping rule: if dose 1 is the only safe dose, allocate up to 9 pts.
stop.rule <- 9 

eff.stg1(dose = dose, dose.tox = dose.tox, p1 = p_no, p2 = p_yes, K = K, 
coh.size = coh.size, m, v, nbb = 100)

}
