% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/events.R
\name{get_events}
\alias{get_events}
\title{Flow Fluctuation Events and Metrics}
\usage{
get_events(x, mc.cores = 2L, omit.constant = TRUE, omit.na = TRUE, ...)
}
\arguments{
\item{x}{Data frame (time series) of stage measurements which contains at least a column with ID of the gauging station (default: column index 1) column with date-time values (default: columns index 2) in character representation and a column with flow rates (default: column index 3). If the column indices differ from \code{c(1, 2, 3)}, they have to be specified as \code{...} argument in the format \code{c(i, j, k)}.}

\item{mc.cores}{Number of cores to use with \code{\link[parallel:mclapply]{parallel::mclapply()}}. On Windows, this will be set to 1.}

\item{omit.constant}{A logical. If \code{FALSE} (default) it does not return events with constant measurements. Otherwise these events are included.}

\item{omit.na}{A logical. If \code{FALSE} (default) it does not return missing value events. Otherwise these events are included.}

\item{...}{Arguments to be passed to \code{\link[=flow]{flow()}} to specify the date-time format in the input data (default: \code{dd.mm.YYYY HH:MM}), the time zone used for the conversion (default: \code{Etc/GMT-1}) and the column indices in the input data, which contain date-time values and flow rate values. The default indices are 1 (ID), 2 (date-time) and 3 (flow rate, Q), i.e. \code{cols = c(1, 2, 3)}.}
}
\value{
A data frame which contains for every event in a given time series all metrics (\code{\link[=all_metrics]{all_metrics()}}), gauging station ID, event type, and starting time of an event.
Included metrics are \code{\link[=amp]{amp()}}, \code{\link[=mafr]{mafr()}}, \code{\link[=mefr]{mefr()}}, \code{\link[=dur]{dur()}}, \code{\link[=fr]{fr()}}. These metrics are only computed for increasing (IC) and decreasing (DC) events.
For all other events the values are set to 0 except for flow ratio that is set to 1.
Event types are defined as follows:
\itemize{
  \item 0: Constant event after NA event or constant event as first event in time series
  \item 1: Constant event after DC
  \item 2: Increasing event (IC)
  \item 3: Constant event after IC
  \item 4: Decreasing event (DC)
  \item 5: NA event
}
}
\description{
Given a data frame (time series) of stage measurements, all increase (IC) and decrease (DC) events are determined and all metrics implemented in the package \pkg{hydropeak} (see \code{\link[=all_metrics]{all_metrics()}}) are computed and combined to a data frame.
Optionally, NA events and constant events can be included. NA events occur due to missing stage measurement values. The beginning of NA events refers to the last measurement with a non-missing Q value.
Constant events are events where the Q values stay constant over time.
An event is uniquely identifiable through the combination of the event starting time (\code{Time}) and the gauging station identifier (\code{ID}).
}
\examples{
# Data with multiple events and different stations
data(Q)
get_events(Q)

# including constant events
get_events(Q, omit.constant = FALSE)
}
