% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/WaterLevelDataFrame-methods.R
\name{setGaugingStations<-}
\alias{setGaugingStations<-}
\alias{setGaugingStations<-,WaterLevelDataFrame,data.frame-method}
\alias{setGaugingStations<--method}
\title{Set a WaterLevelDataFrame's slot gauging_stations}
\usage{
setGaugingStations(x) <- value

\S4method{setGaugingStations}{WaterLevelDataFrame,data.frame}(x) <- value
}
\arguments{
\item{x}{an object of class \linkS4class{WaterLevelDataFrame}.}

\item{value}{a new value of class \code{\link[base]{data.frame}} for the
\code{gauging_stations} slot. \code{value} has to be a 
\code{\link[base]{data.frame}} with the following columns and column types:
id (\code{integer}), gauging_station (\code{character}),
uuid (\code{character}), km (\code{numeric}), km_qps (\code{numeric}),
water_shortname (\code{character}), longitude (\code{numeric}), latitude
(\code{numeric}), mw (\code{numeric}), pnp (\code{numeric}), w
(\code{numeric}), wl (\code{numeric}), n_wls_below_w_do (\code{integer}),
n_wls_above_w_do (\code{integer}), n_wls_below_w_up (\code{integer}),
n_wls_above_w_up (\code{integer}), name_wl_below_w_do (\code{character}),
name_wl_above_w_do (\code{character}), name_wl_below_w_up
(\code{character}), name_wl_above_w_up (\code{character}),
w_wl_below_w_do (\code{numeric}), w_wl_above_w_do (\code{numeric}),
w_wl_below_w_up (\code{numeric}), w_wl_above_w_up (\code{numeric}),
weight_up (\code{numeric}), weight_do (\code{numeric}).}
}
\value{
The function sets a new \code{value} for the slot
  \code{gauging_stations} and returns an object of class
  \linkS4class{WaterLevelDataFrame}. Since \code{value} is normally generated
  inside the functions \code{\link{waterLevel}} or
  \code{\link{waterLevelPegelonline}} this function is of very little use
  outside these functions.
}
\description{
A function to set the slot \code{gauging_stations} of an object
  of class \linkS4class{WaterLevelDataFrame}.
}
\examples{
wldf <- WaterLevelDataFrame(river   = "Elbe",
                            time    = as.POSIXct("2016-12-21"),
                            station = seq(257, 262, 0.1))
wldf <- waterLevel(wldf)

df <- data.frame(id = integer(),
                 gauging_station    = character(),
                 uuid               = character(),
                 km                 = numeric(),
                 km_qps             = numeric(),
                 river              = character(),
                 longitude          = numeric(),
                 latitude           = numeric(),
                 mw                 = numeric(),
                 mw_timespan        = character(),
                 pnp                = numeric(),
                 w                  = numeric(),
                 wl                 = numeric(),
                 n_wls_below_w_do   = integer(),
                 n_wls_above_w_do   = integer(),
                 n_wls_below_w_up   = integer(),
                 n_wls_above_w_up   = integer(),
                 name_wl_below_w_do = character(),
                 name_wl_above_w_do = character(),
                 name_wl_below_w_up = character(),
                 name_wl_above_w_up = character(),
                 w_wl_below_w_do    = numeric(),
                 w_wl_above_w_do    = numeric(),
                 w_wl_below_w_up    = numeric(),
                 w_wl_above_w_up    = numeric(),
                 weight_up          = numeric(),
                 weight_do          = numeric(),
                 stringsAsFactors   = FALSE)
setGaugingStations(wldf) <- df

}
\seealso{
\code{\link{getGaugingStations-method}}
}
