% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotShiny.R
\name{plotShiny}
\alias{plotShiny}
\title{Plot a WaterLevelDataFrame in Shiny}
\usage{
plotShiny(
  wldf,
  add_flys = TRUE,
  add_flys_labels = TRUE,
  add_weighting = TRUE,
  ...
)
}
\arguments{
\item{wldf}{an object of class \linkS4class{WaterLevelDataFrame}.}

\item{add_flys}{\code{logical} determining whether the used 
\href{http://www.bafg.de/DE/08_Ref/M2/03_Fliessgewmod/01_FLYS/flys_node.html}{FLYS3}
water levels should be plotted.}

\item{add_flys_labels}{\code{logical} determining whether the used 
\href{http://www.bafg.de/DE/08_Ref/M2/03_Fliessgewmod/01_FLYS/flys_node.html}{FLYS3}
water levels should be labelled.}

\item{add_weighting}{\code{logical} determining whether the weighting of
gauging data at the gauging stations should be labelled.}

\item{\dots}{further graphical parameters passed to 
\code{\link[graphics]{plot.default}}.}
}
\value{
A plot of a \linkS4class{WaterLevelDataFrame}.
}
\description{
This convenience function enables the easy visualisation of 
  interpolated water levels stored as \linkS4class{WaterLevelDataFrame} using
  the \R package \href{https://CRAN.R-project.org/package=shiny}{shiny}. The 
  results of functions like \code{\link{waterLevel}} and
  \code{\link{waterLevelPegelonline}} can be plotted interactively so that 
  the computation process itself becomes visible.
}
\examples{
wldf <- WaterLevelDataFrame(river   = "Elbe",
                            time    = as.POSIXct("2016-12-21"),
                            station = seq(257, 262, 0.1))
wldf <- waterLevel(wldf, shiny = TRUE)
plotShiny(wldf, TRUE, TRUE, TRUE)

}
\references{
\insertRef{bundesanstalt_fur_gewasserkunde_flys_2016}{hyd1d}
}
