% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/seg.R
\name{gsegmat}
\alias{gsegmat}
\title{Segregation probabilities of gametes}
\usage{
gsegmat(alpha, ploidy)
}
\arguments{
\item{alpha}{A numeric vector containing the double reduction parameter(s).
This should be a
vector of length \code{floor(ploidy/4)} where \code{alpha[i]}
is the probability of exactly \code{i} pairs of IBDR alleles
being in the gamete. Note that \code{sum(alpha)} should be less than
1, as \code{1 - sum(alpha)} is the probability of no double reduction.}

\item{ploidy}{The ploidy of the species. This should be an even positive
integer.}
}
\value{
A matrix of dimension \code{ploidy + 1} by \code{ploidy / 2 + 1}.
Element (i, j) is the probability that a parent carrying dosage
j - 1 produces a gamete with dosage i - 1.
}
\description{
Produces the segregation probabilities for gamete dosages given
parental dosages and the double reduction rate.
}
\examples{
gsegmat(alpha = NULL, ploidy = 2)

gsegmat(alpha = 1/6, ploidy = 4)

gsegmat(alpha = 0.3, ploidy = 6)

gsegmat(alpha = c(0.35, 0.02), ploidy = 8)

gsegmat(alpha = c(0.4, 0.05), ploidy = 10)

}
\author{
David Gerard
}
