% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/properties-border-generics.R
\name{border-colors}
\alias{border-colors}
\alias{map_left_border_color}
\alias{set_left_border_color}
\alias{map_right_border_color}
\alias{set_right_border_color}
\alias{map_top_border_color}
\alias{set_top_border_color}
\alias{map_bottom_border_color}
\alias{set_bottom_border_color}
\alias{left_border_color<-}
\alias{right_border_color<-}
\alias{top_border_color<-}
\alias{bottom_border_color<-}
\alias{left_border_color}
\alias{right_border_color}
\alias{top_border_color}
\alias{bottom_border_color}
\alias{`left_border_color<-`}
\alias{`right_border_color<-`}
\alias{`top_border_color<-`}
\alias{`bottom_border_color<-`}
\title{Set border colors}
\usage{
left_border_color(ht)
left_border_color(ht) <- value
set_left_border_color(ht, row, col, value )
map_left_border_color(ht, row, col, fn)

right_border_color(ht)
right_border_color(ht) <- value
set_right_border_color(ht, row, col, value )
map_right_border_color(ht, row, col, fn)

top_border_color(ht)
top_border_color(ht) <- value
set_top_border_color(ht, row, col, value )
map_top_border_color(ht, row, col, fn)

bottom_border_color(ht)
bottom_border_color(ht) <- value
set_bottom_border_color(ht, row, col, value )
map_bottom_border_color(ht, row, col, fn)
}
\arguments{
\item{ht}{A huxtable.}

\item{row}{A row specifier. See \link{rowspecs} for details.}

\item{col}{An optional column specifier.}

\item{fn}{A mapping function. See \link{mapping-functions} for details.}

\item{value}{A valid R color, e.g. \code{"red"}, \code{"#FF0000"}.}
}
\description{
These functions set border colors.
}
\details{
Borders are always "collapsed": \code{right_border_color(ht)[, 1]} is
the same as \code{left_border_color(ht)[, 2]}, and setting one sets the other.
}
\section{Limitations}{

\itemize{
\item Transparent borders with the alpha channel set are not guaranteed to work.
}
}

\examples{

jams <- set_all_borders(jams)
bottom_border_color(jams)[1, ] <- "red"
jams

set_bottom_border_color(jams, "blue")

}
\seealso{
\link{set-multiple}, \code{\link[=brdr]{brdr()}}

Other border properties: 
\code{\link{border-styles}},
\code{\link{borders}}
}
\concept{border properties}
