% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/restack-split.R
\name{restack-across-down}
\alias{restack-across-down}
\alias{restack_across}
\alias{restack_down}
\title{Restack huxtables across/down the page}
\usage{
restack_across(
  ht,
  rows,
  headers = TRUE,
  on_remainder = c("warn", "stop", "fill")
)

restack_down(
  ht,
  cols,
  headers = TRUE,
  on_remainder = c("warn", "stop", "fill")
)
}
\arguments{
\item{ht}{A huxtable}

\item{rows, cols}{How many rows/columns the new result should have.}

\item{headers}{Logical. Take account of header rows/columns?}

\item{on_remainder}{String. "warn", "stop" or "fill". See below.}
}
\value{
A new huxtable.
}
\description{
\itemize{
\item \code{restack_across()} splits a huxtable horizontally, then joins the parts
up side by side.
\item \code{restack_down()} splits a huxtable vertically, then joins the parts up
top to bottom.
}
}
\details{
If \code{headers} is \code{TRUE}, header rows/columns will be repeated across/down
the restacked huxtable as necessary.

\code{on_remainder} determines what happens if the huxtable could not be evenly
divided for restacking:
\itemize{
\item \code{"stop"}: stop with an error.
\item \code{"fill"}: fill the remainder with empty cells.
\item \code{"warn"} (the default): issue a warning, then fill the remainder with empty
cells.
}
}
\examples{

ht <- as_hux(matrix(LETTERS[1:4], 2, 2))
ht <- set_all_borders(ht)
ht

restack_down(ht, 1)
restack_across(ht, 1)

# headers:
restack_across(jams, 2)
restack_across(jams, 2,
      headers = FALSE)

# on_remainder:
restack_across(jams, 3,
      on_remainder = "fill")

}
\seealso{
\link{split-across-down}
}
