% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc.R
\name{add_footnote}
\alias{add_footnote}
\title{Add a row with a footnote}
\usage{
add_footnote(ht, text, border = 0.8, number_format = NA, ...)
}
\arguments{
\item{ht}{A huxtable.}

\item{text}{Text for the footnote.}

\item{border}{Width of the footnote's top border. Set to 0 for no border, or
\code{NULL} to leave the border unchanged.}

\item{number_format}{Number format for the footnote cell.}

\item{...}{Other properties, passed to \code{\link[=set_cell_properties]{set_cell_properties()}} for the footnote cell.}
}
\value{
The modified huxtable
}
\description{
This adds a single row at the bottom. The first cell contains the footnote; it spans
all table columns and has an optional border above.
}
\examples{
jams <- add_footnote(jams,
      "* subject to availability")
jams
}
