% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/properties-table.R
\name{height}
\alias{height}
\alias{height<-}
\alias{set_height}
\title{Set the table height}
\usage{
height(ht)
height(ht) <- value
set_height(ht, value)
}
\arguments{
\item{ht}{A huxtable.}

\item{value}{A number or string. Set to \code{NA} to reset to the default, which is
\code{NA}.}
}
\value{
\code{height()} returns the \code{height} property.
\code{set_height()} returns the modified huxtable.
}
\description{
\verb{height()`` sets the height of the entire table, while [row_height()] sets the height of individual rows. A numeric height is treated as a proportion of the containing block (HTML) or }\\textheight` (LaTeX). A character height
must be a valid CSS or LaTeX dimension.
}
\examples{

height(jams) <-  0.4
height(jams)
}
\seealso{
Other table measurements: 
\code{\link{col_width}()},
\code{\link{row_height}()},
\code{\link{width}()}
}
\concept{table measurements}
