% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/merge.R
\name{merge_cells}
\alias{merge_cells}
\title{Merge a range of cells}
\usage{
merge_cells(ht, row, col)
}
\arguments{
\item{ht}{A huxtable.}

\item{row}{A row specifier. See \link{rowspecs} for details.}

\item{col}{An optional column specifier.}
}
\value{
The \code{ht} object.
}
\description{
\code{merge_cells()} merges a rectangle of cells into a single displayed cell,
by setting \code{\link[=colspan]{colspan()}} and \code{\link[=rowspan]{rowspan()}}.
}
\details{
\code{merge_cells(ht, c(min_row, max_row), c(min_col, max_col))} is equivalent to

\if{html}{\out{<div class="sourceCode">}}\preformatted{  colspan(ht)[min_row, min_col] <- max_col - min_col + 1
  rowspan(ht)[min_row, min_col] <- max_row - min_row + 1
}\if{html}{\out{</div>}}
}
\section{Cell content}{

In merged cell ranges, only the top left cell's content is displayed.
In addition, when you merge cells (either by setting \code{\link[=colspan]{colspan()}} or
\code{\link[=rowspan]{rowspan()}}, or using \code{\link[=merge_cells]{merge_cells()}} and friends) the content of the top
left cell is copied to other cells. This prevents unexpected changes to
content if you reorder or subset rows and columns.
}

\examples{

ht <- hux(a = 1:3, b = 1:3)
ht <- set_all_borders(ht, 1)
merge_cells(ht, 2:3, 1:2)

}
\seealso{
Other cell merging: 
\code{\link{merge_across}()},
\code{\link{merge_repeated_rows}()}
}
\concept{cell merging}
