% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/attributes.R
\name{set_all_borders}
\alias{set_all_borders}
\title{Set all borders}
\usage{
set_all_borders(ht, row, col, value, byrow = FALSE)
}
\arguments{
\item{ht}{A huxtable.}

\item{row}{A row specifier. See \code{\link{rowspecs}} for details.}

\item{col}{An optional column specifier.}

\item{value}{A numeric vector or matrix giving border widths in points. Set to 0 for no border. Set to \code{NA} to reset to the default.}

\item{byrow}{If \code{TRUE}, fill in values by row rather than by column.}
}
\value{
The modified huxtable.
}
\description{
This is a convenience function which sets left, right, top and bottom borders
for the specified cells.
}
\examples{
ht <- huxtable(a = 1:3, b = 1:3)
set_all_borders(ht, 1:3, 1:2, 1)
}
\seealso{
\code{\link[=left_border]{left_border()}}, \code{\link[=set_outer_borders]{set_outer_borders()}}
}
