% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/attributes.R
\name{width}
\alias{width}
\alias{width<-}
\alias{set_width}
\alias{width.huxtable}
\alias{width<-.huxtable}
\title{Table width}
\usage{
width(ht)
width(ht) <- value
set_width(ht, value)
}
\arguments{
\item{ht}{A huxtable.}

\item{value}{A length-one vector. If numeric, \code{value} is treated as a proportion of the surrounding block width (HTML) or text width (LaTeX). If character, it must be a valid CSS or LaTeX width. Set to \code{NA} for the default.}
}
\value{
For \code{width}, the \code{width} attribute.
For \code{set_width}, the \code{ht} object.
}
\description{
Functions to get or set the table-level table width property of a huxtable.
}
\examples{

ht <- huxtable(a = 1:3, b = 1:3)
width(ht) <-  0.8
width(ht)

}
\seealso{
Other table measurements: \code{\link{height}}
}
