% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/row-col-fns.R
\name{is_a_number}
\alias{is_a_number}
\title{Does an object look like a number?}
\usage{
is_a_number(x)
}
\arguments{
\item{x}{An object.}
}
\value{
A logical object with the same dimensions as \code{x}.
}
\description{
A convenience function that returns \code{TRUE} if an object either is numeric or
can be converted to a number. For data frames, it returns a matrix of the same
dimensions as the data frame.
}
\examples{

is_a_number(1.0)
is_a_number("1.0")
is_a_number("a")
ht <- hux(a = 1:3, b = 1:3, add_colnames = TRUE)
is_a_number(ht)
}
