% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/attributes.R
\name{text_color}
\alias{text_color}
\alias{text_color<-}
\alias{set_text_color}
\alias{text_color.huxtable}
\alias{text_color<-.huxtable}
\title{Get or Set Cell Text Color}
\usage{
text_color(ht)
text_color(ht) <- value
set_text_color(ht, row, col, value)
}
\arguments{
\item{ht}{A huxtable.}

\item{value}{A vector or matrix of R colors. Set to \code{NA} to reset to the default.}

\item{row}{A row specifier.}

\item{col}{A column specifier.}
}
\value{
For \code{text_color}, the \code{text_color} attribute.
For \code{set_text_color}, the \code{ht} object.
}
\description{
Functions to get or set the cell text color property of huxtable table cells.
}
\examples{

ht <- huxtable(a = 1:3, b = 1:3)
text_color(ht) <-  'navy'
text_color(ht)

}
\seealso{
Other formatting functions: \code{\link{background_color}},
  \code{\link{bold}}, \code{\link{font_size}},
  \code{\link{font}}, \code{\link{na_string}},
  \code{\link{number_format}}
}
