% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/attributes.R
\name{font_size}
\alias{font_size}
\alias{font_size<-}
\alias{set_font_size}
\alias{font_size.huxtable}
\alias{font_size<-.huxtable}
\title{Get or Set Font Size}
\usage{
font_size(ht)
font_size(ht) <- value
set_font_size(ht, row, col, value)
}
\arguments{
\item{ht}{A huxtable.}

\item{value}{A numeric vector. This sets the font size in points. Set to \code{NA} to reset to the default.}

\item{row}{A row specifier.}

\item{col}{A column specifier.}
}
\value{
For \code{font_size}, the \code{font_size} attribute.
For \code{set_font_size}, the \code{ht} object.
}
\description{
Functions to get or set the font size property of huxtable table cells.
}
\examples{

ht <- huxtable(a = 1:3, b = 1:3)
font_size(ht) <-  14
font_size(ht)

}
\seealso{
Other formatting functions: \code{\link{background_color}},
  \code{\link{bold}}, \code{\link{font}},
  \code{\link{na_string}}, \code{\link{number_format}},
  \code{\link{text_color}}
}
