% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/drop_col.R
\name{drop_col}
\alias{drop_col}
\alias{drop_cols}
\title{Drop column or columns}
\usage{
drop_col(DT, var, checkDT = TRUE)

drop_cols(DT, vars, checkDT = TRUE)
}
\arguments{
\item{DT}{A \code{data.table}.}

\item{var}{Quoted column to drop.}

\item{checkDT}{Should the function check \code{DT} is a \code{data.table}?}

\item{vars}{Character vector of columns to drop. Only the intersection is dropped; 
if any \code{vars} are not in \code{names(DT)}, no warning is emitted.}
}
\value{
\code{DT} with specified columns removed.
}
\description{
Drop column or columns
}
\examples{
if (requireNamespace("data.table", quietly = TRUE)) {
  library(data.table)
  DT <- data.table(x = 1, y = 2, z = 3)
  
  drop_col(DT, "x")
}

}
