% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/selector.R
\name{selector}
\alias{selector}
\title{Fast selection of \code{data.table} columns}
\usage{
selector(DT, ..., cols = NULL, preserve.key = TRUE, shallow = FALSE)
}
\arguments{
\item{DT}{A \code{data.table}.}

\item{...}{Unquoted columns names.}

\item{cols}{Character vector of column names.}

\item{preserve.key}{(logical, default: \code{TRUE}) Reapply the key (if \code{DT} has one)?}

\item{shallow}{(logical, default: \code{FALSE}) Should the result be a shallow
\code{\link[data.table]{copy}} of 
\code{DT}'s columns or should the columns be assigned by reference? If \code{TRUE},
any modification to the result also modifies the selected columns in \code{DT}.}
}
\value{
\code{DT} with the selected columns.
}
\description{
Present since \code{hutils 1.2.0}.
}
\examples{
RQ("nycflights13", no = {
 library(nycflights13)
 library(data.table)
 fs <- as.data.table(flights)
 fs1 <- selector(fs, year, month, day, arr_delay)
 fs1[, arr_delay := NA]
})
}
