% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/if_else.R
\name{if_else}
\alias{if_else}
\title{Vectorized if}
\source{
Original code but obviously heavily inspired by \url{https://CRAN.R-project.org/package=dplyr}.
}
\usage{
if_else(condition, true, false, missing = NULL)
}
\arguments{
\item{condition}{Logical vector}

\item{true, false}{Where condition is \code{TRUE}/\code{FALSE}, use the corresponding\code{true}/\code{no} value.
They must have the same \code{\link[base]{type}} as each other and be the same length as \code{condition} or length-one.}

\item{missing}{If condition is \code{NA}, use the corresponding \code{na} value. Like\code{true} and\code{false}, must
be of the same type and have the same length as condition, unless it has length one.}
}
\value{
Where \code{condition} is \code{TRUE}, the corresponding value in \code{true}; 
where \code{condition} is \code{FALSE}, the corresponding value in \code{false}.
Where \code{condition} is \code{NA}, then the corresponding value in \code{na} -- 
unless \code{na} is \code{NULL} (the default) in which case the value will be \code{NA} (with the same
type as \code{true}.)
}
\description{
Lightweight \code{dplyr::if_else} with the virtues and vices that come from such an approach.
Attempts to replicate \code{dplyr::if_else} but written in base R for faster compile time.
\code{hutils::if_else} should be faster than \code{dplyr::if_else} \dots{} when it works, 
but will not work on lists or on factors. 
Additional attributes may be dropped.
}
\details{
If the result is expected to be a factor then the conditions for type safety
are strict and may be made stricter in future.
}
