% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/humarray.R
\name{id.to.rs}
\alias{id.to.rs}
\title{Convert from chip ID labels to dbSNP rs-ids}
\usage{
id.to.rs(ids)
}
\arguments{
\item{ids}{character, meant to be a list of chip ids, but if rs-ids are present they will not be altered.}
}
\value{
A character vector of SNP rs-ids, where the input was chip ids, rs-ids or a mixture, any text
other than this will result in NA values being returned in the character vector output.
}
\description{
Most SNPs will have an 'rs-id' from dbSNP/HapMap, and these are often the standard for reporting or
annotation lookup. These can differ from the IDs used on the chip. This functions looks at the current
snp support (ChipInfo object) and returns rs-ids in place of chip IDs. Currently rs-ids are always 
from build37.
}
\examples{
id.to.rs(c("imm_11_2138800","rs9467354","vh_1_1108138")) # middle one is already a rs.id
}
\seealso{
\code{\link{rs.to.id}}, \code{\link{GENE.to.ENS}}, \code{\link{ENS.to.GENE}}
}
\author{
Nicholas Cooper \email{nick.cooper@cimr.cam.ac.uk}
}
