% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/humarray.R
\name{nearest.gene}
\alias{nearest.gene}
\title{Retrieve the 'n' closest GENE labels or positions near specified locus}
\usage{
nearest.gene(chr, pos, n = 1, side = c("either", "left", "right"),
  ids = TRUE, limit = NULL, build = NULL, ga = NULL)
}
\arguments{
\item{chr}{integer, chromosome, should be a number from 1 to 25, where 23,24,25 are X,Y,MT}

\item{pos}{integer, genomic position, should be between 1 and the length of the chromosome 'chr'}

\item{n}{integer, the number of nearest GENEs to seek, if there aren't enough in the annotation
then NAs will fill the gaps to force the return value length to equal 'n'}

\item{side}{character, can be 'either', 'left' or 'right' and specifies which side of the 'pos'
to look for nearest genes (where left is decreasing genomic position and right is increasing)}

\item{ids}{logical, if TRUE will return GENE labels, 
or if FALSE will return the chromosome positions of the genes}

\item{limit}{integer, a limit on the maximum distance from the position 'pos' can be specified}

\item{build}{integer whether to use build 36/37 parameters, 36/37 is preferred, but can enter
using any form recognised by ucsc.sanitizer()}

\item{ga}{RangedData object, e.g, result of get.gene.annot(); gene annotation to save download
time if repeatedly calling this function}
}
\value{
Set of GENE ids (when ids=TRUE), or otherwise genomic positions within chromosome 'chr'.
If the number of gemes on the chromosome or the bounds of the 'side' and 'limit' parameters
restrict the number returned to less than 'n' then the return value will be padded with NAs.
}
\description{
Retrieve the 'n' closest GENE labels or positions near specified locus
}
\examples{
\donttest{
nearest.gene(1,159000000,n=10) # return ids
nearest.gene(1,159000000,n=10,build=37)
nearest.gene(1,159000000,n=10,build=36,ids=FALSE) # return positions
nearest.gene(1,159000000,n=10,build=37,ids=FALSE)
nearest.gene(6,25000000,n=10,build=37,ids=FALSE,side="left")  # only genes to the left of the locus
nearest.gene(6,25000000,n=10,build=37,ids=FALSE,side="right") # only genes to the right of the locus
}
}
\seealso{
\code{\link{expand.nsnp}}, \code{\link{nearest.snp}}, \code{\link{get.gene.annot}}
}
