% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/humarray.R
\name{get.recombination.map}
\alias{get.recombination.map}
\title{Get HapMap recombination rates for hg18 (build 36)}
\usage{
get.recombination.map(dir = NULL, verbose = TRUE, refresh = FALSE,
  compress = FALSE)
}
\arguments{
\item{dir}{character, location to store binary file with the recombination maps for
chromosomes 1-22. If NULL then getOption("save.annot.in.current")>=1 will result in
this file being stored in the current directory, or if <=0, then this file will not
be stored.}

\item{verbose}{logical, if the binary file is not already downloaded, when verbose
is TRUE, there will be some output to the console indicating the progress of the
download. If FALSE, all output is suppressed.}

\item{refresh}{logical, if you already have the binary file in the current directory,
this argument will let you re-download and re-generate this file, e.g, if the file
is modified or corrupted this will make a new one without having to manually delete it}

\item{compress}{logical, this argument is passed to 'save' and will result in a larger
binary file size, but quicker loading times, so 'FALSE' is recommended for faster retrieval.}
}
\value{
Returns a list object of length 22, containing the recombination map files
as 22 separate data.frame's.
}
\description{
Recombination rate files can be used to calculate recombination distances
for genome locations, in centimorgans. This function downloads these reference
files from the hapmap NCBI website. At the time of writing they were only 
availble for build 36. If using a more recent build I suggest using the
conversion function conv.37.36(), then recomWindow(), then conv.36.37() to 
get recombination distances for other builds. If getOption("save.annot.in.current")
is <=0 then no files will be kept. Otherwise an object containing this mapping data
will be saved in the local directory if dir=NULL, or else in the directory specified.
Allowing this reference to be saved will greatly increase the speed of this function
for subsequent lookups
}
\examples{
\donttest{
## not run as it takes roughly 2 minutes to download and read-in ##
setwd(tempdir())
rec.map <- get.recombination.map(getwd())
file.on.disk <- "rrates_genetic_map_chr_1_22_b36.RData"
if(file.exists(file.on.disk)) { unlink(file.on.disk) } # remove the downloaded file
}
}
