% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/humarray.R
\name{convert.textpos.to.data}
\alias{convert.textpos.to.data}
\title{Convert a chr:pos1-pos2 vector to a matrix}
\usage{
convert.textpos.to.data(text)
}
\arguments{
\item{text}{character vector, format like chr:pos1-pos2}
}
\value{
a matrix of the same length as 'ranges' with columns chr, start and end, and
rownames will be the same as the original text vector.
}
\description{
Takes standard text positions, such as what you might see on the UCSC genome browser, such as 
chr1:10,000,234-11,000,567 for a range, or chrX:234,432 for a SNP, and converts to 
with cols: chr, start, end.
}
\examples{
txt <- ranged.to.txt(rranges())
convert.textpos.to.data(txt)
}
\seealso{
\code{\link{ranged.to.txt}}
}
