% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/oauth-flow-device.R
\name{oauth_flow_device}
\alias{oauth_flow_device}
\title{OAuth flow: device}
\usage{
oauth_flow_device(
  client,
  auth_url,
  pkce = FALSE,
  scope = NULL,
  auth_params = list(),
  token_params = list()
)
}
\arguments{
\item{client}{An \code{\link[=oauth_client]{oauth_client()}}.}

\item{auth_url}{Authorization url; you'll need to discover this by reading
the documentation.}

\item{pkce}{Use "Proof Key for Code Exchange"? This adds an extra layer of
security and should always be used if supported by the server.}

\item{scope}{Scopes to be requested from the resource owner.}

\item{auth_params}{List containing additional parameters passed to \code{oauth_flow_auth_code_url()}}

\item{token_params}{List containing additional parameters passed to the
\code{token_url}.}
}
\value{
An \link{oauth_token}.
}
\description{
These functions implement the OAuth device flow, as defined
by \href{https://datatracker.ietf.org/doc/html/rfc8628}{rfc8628}. It's designed
for devices that don't have access to a web browser (if you've ever
authenticated an app on your TV, this is probably the flow you've used),
but it also works well from within R.

This specification allows also some subspecifications:
\itemize{
\item \code{oauth_flow_auth_code_pkce()} is also reused here to generate code
verifier, method, and challenge components as needed for PKCE, as
defined in \href{https://datatracker.ietf.org/doc/html/rfc7636}{rfc7636}.
}
}
\seealso{
Other OAuth flows: 
\code{\link{oauth_flow_auth_code}()},
\code{\link{oauth_flow_bearer_jwt}()},
\code{\link{oauth_flow_client_credentials}()},
\code{\link{oauth_flow_password}()},
\code{\link{oauth_flow_refresh}()}
}
\concept{OAuth flows}
\keyword{internal}
