% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/oauth-flow-device.R
\name{req_oauth_device}
\alias{req_oauth_device}
\title{OAuth authentication with device flow}
\usage{
req_oauth_device(
  req,
  client,
  cache_disk = FALSE,
  cache_key = NULL,
  scope = NULL,
  auth_params = list(),
  token_params = list()
)
}
\arguments{
\item{req}{A \link{request}.}

\item{client}{An \code{\link[=oauth_client]{oauth_client()}}.}

\item{cache_disk}{Should the access token be cached on disk? This reduces
the number of times that you need to re-authenticate at the cost of
storing access credentials on disk. Cached tokens are encrypted and
automatically deleted 30 days after creation.}

\item{cache_key}{If you want to cache multiple tokens per app, use this
key to disambiguate them.}

\item{scope}{Scopes to be requested from the resource owner.}

\item{auth_params}{List containing additional parameters passed to \code{oauth_flow_auth_code_url()}}

\item{token_params}{List containing additional parameters passed to the
\code{token_url}.}
}
\value{
A modified HTTP \link{request}.
}
\description{
This uses \code{\link[=oauth_flow_device]{oauth_flow_device()}} to generate an access token, which is
then used to authentication the request with \code{\link[=req_auth_bearer_token]{req_auth_bearer_token()}}.
The token is automatically cached (either in memory or on disk) to minimise
the number of times the flow is performed.
}
\examples{
client <- oauth_client("example", "https://example.com/get_token")
req <- request("https://example.com")

req \%>\% req_oauth_device(client)
}
