% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/expect-request-header.R
\name{expect_request_header}
\alias{expect_request_header}
\title{Test that an HTTP request is made with a header}
\usage{
expect_request_header(
  expr,
  ...,
  fixed = FALSE,
  ignore.case = FALSE,
  perl = FALSE,
  useBytes = FALSE
)
}
\arguments{
\item{expr}{Code to evaluate}

\item{...}{Named headers to match. Values should either be a string (length-1
character), which will be passed to \code{\link[testthat:expect_match]{testthat::expect_match()}}, or \code{NULL} to
assert that the named header is not present in the request. To assert that a
header is merely present in the request, without asserting anything about its
contents, provide an empty string (\code{""}). Header names are always
case-insensitive; header values will be matched using the following
parameters:}

\item{fixed}{logical. If \code{TRUE}, \code{pattern} is a string to be
    matched as is.  Overrides all conflicting arguments.}

\item{ignore.case}{logical. if \code{FALSE}, the pattern matching is \emph{case
      sensitive} and if \code{TRUE}, case is ignored during matching.}

\item{perl}{logical.  Should Perl-compatible regexps be used?}

\item{useBytes}{logical.  If \code{TRUE} the matching is done
    byte-by-byte rather than character-by-character.  See
    \sQuote{Details}.}
}
\value{
The value of \code{expr} if there are no expectation failures
}
\description{
This expectation checks that HTTP headers (and potentially header values)
are present in a request. It works both in the mock HTTP contexts and on
"live" HTTP requests.
}
\examples{
\dontshow{if (FALSE) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}

library(httr2)
expect_request_header(
  request("http://httpbin.org") \%>\%
    req_headers(Accept = "image/png") \%>\%
    req_perform(),
  accept = "image/png",
  `x-fake-header` = NULL
)
expect_request_header(
  request("http://httpbin.org") \%>\%
    req_headers(Accept = "image/png") \%>\%
    req_perform(),
  accept = ""
)
\dontshow{\}) # examplesIf}
}
