% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hs_tstep.R
\name{hs_tstep}
\alias{hs_tstep}
\title{hts time series with fixed timestep}
\usage{
hs_tstep()
}
\value{
hts files at the requested timestep with a suffix giving the timestep in minutes, i.e.
1440 for the daily timestep. In the case or monthly timestep, the suffixes are: M for the
current case, C for the climatology, G for the gapfilled file.

Optionally, two Excel files with values in "calendar form": one with
daily data and one with monthly data, the fist one with a ad_ prefix and the
second one with the am_ prefix.
}
\description{
Computes time-series with a fixed timestep from infra-daily to monthly within a shiny web page.
}
\details{
First of all, one must select a "starting" hts file, instantaneous or already with
a fixed timestep.

Then one must choose the computing time-step and mode, between the possible choices. Note that
the timezone considered is the timezone of the "starting" file.

Possible time-steps are: 5, 10 or 30 minutes, 1, 2, 3, 6 or 12 hours, 1 day, 1 month.
It shall be noted that when computing the monthly time step, the daily time step is previously computed.

Possible modes are: average, sum, max or min. For monthly time step, max and min offers two options:
daily max averages, respectively min, or absolute, respectively min.

In the case of a daily timestep, a shift value (in hours) allows to shift the time interval.
For example if shift = 6, the date is computed from 6am until 6am the following day. The result is
dated in the middle of the interval, i.e. if shift = 6; the datetime is 18.

In the case of a monthly timestep, associated additional time series can be optionally
computed:

\itemize{
  \item A mean monthly climatology, taking into account or not the missing daily values with the
  option "remove NA". Climatology files are by convention awarded to year 2000.
  \item Excel files: with a calendar presentation (days in rows, months in columns,
   years in sheets): option caledit_j ; with the monthly means (or sums): option caledit_m.
  \item Missing values can be replaced by the mean of the existing values for
  other years: option gapfill.
  \item Extract year stat
}

The output files are written in same folder as the starting hts file.
}
\author{
P. Chevallier - Oct 2017 - Sep 2023
}
