% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/p_line_app.R
\name{p_line_app}
\alias{p_line_app}
\title{Plot lines}
\usage{
p_line_app(
  nbst,
  rpal = 0,
  savefig = FALSE,
  width = 8,
  height = 6,
  fileo = "plot.png"
)
}
\arguments{
\item{nbst}{Number of time-series to be plotted (default 1)}

\item{rpal}{Color palette settings 0 (default); 1 (mapalette) or 2 (manual)}

\item{savefig}{Save plot as png (default FALSE)}

\item{width}{Plot width (x100 pixels) (default = 8)}

\item{height}{Plot height (x100 pixels) (default = 6)}

\item{fileo}{Name of the plot file including extension (png, jpg or pdf) default = "plot.png")}
}
\value{
A ggplot2 object.
}
\description{
Application of the functions p_line \code{\link{p_line}}
for plotting lines. The resulting plot
can be saved as .png, .jpg or .pdf files.
}
\details{
The number of time-series to be plotted is limited to 8, with option rpal = 0, 12 otherwise.

If savefig=TRUE, the plot is saved in the working directory. Following the
chosen extension, the file is formatted as .png, .jpg or .pdf. The default is
 "plot.png".
}
\examples{
\dontrun{

p <- p_line_app(filelist = c(foo1, foo2),pset=TRUE, pfil=TRUE, rpal=1, fileo="plot23.pdf")
}


}
\seealso{
\code{\link{p_line}},  \code{\link{p_bar}}
}
\author{
P. Chevallier - Oct 2017 - Mar 2020
}
