% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/h2_overall.R
\name{h2_overall}
\alias{h2_overall}
\alias{h2_overall.default}
\alias{h2_overall.hstats}
\title{Overall Interaction Strength}
\usage{
h2_overall(object, ...)

\method{h2_overall}{default}(object, ...)

\method{h2_overall}{hstats}(
  object,
  normalize = TRUE,
  squared = TRUE,
  sort = TRUE,
  zero = TRUE,
  ...
)
}
\arguments{
\item{object}{Object of class "hstats".}

\item{...}{Currently unused.}

\item{normalize}{Should statistics be normalized? Default is \code{TRUE}.}

\item{squared}{Should \emph{squared} statistics be returned? Default is \code{TRUE}.}

\item{sort}{Should results be sorted? Default is \code{TRUE}.
(Multi-output is sorted by row means.)}

\item{zero}{Should rows with all 0 be shown? Default is \code{TRUE}.}
}
\value{
An object of class "hstats_matrix" containing these elements:
\itemize{
\item \code{M}: Matrix of statistics (one column per prediction dimension), or \code{NULL}.
\item \code{SE}: Matrix with standard errors of \code{M}, or \code{NULL}.
Multiply with \code{sqrt(m_rep)} to get \emph{standard deviations} instead.
Currently, supported only for \code{\link[=perm_importance]{perm_importance()}}.
\item \code{m_rep}: The number of repetitions behind standard errors \code{SE}, or \code{NULL}.
Currently, supported only for \code{\link[=perm_importance]{perm_importance()}}.
\item \code{statistic}: Name of the function that generated the statistic.
\item \code{description}: Description of the statistic.
}
}
\description{
Friedman and Popescu's statistic of overall interaction strength per
feature, see Details. Use \code{plot()} to get a barplot.
}
\details{
The logic of Friedman and Popescu (2008) is as follows:
If there are no interactions involving feature \eqn{x_j}, we can decompose the
(centered) prediction function \eqn{F} into the sum of the (centered) partial
dependence \eqn{F_j} on \eqn{x_j} and the (centered) partial dependence
\eqn{F_{\setminus j}} on all other features \eqn{\mathbf{x}_{\setminus j}}, i.e.,
\deqn{
  F(\mathbf{x}) = F_j(x_j) + F_{\setminus j}(\mathbf{x}_{\setminus j}).
}
Correspondingly, Friedman and Popescu's statistic of overall interaction
strength of \eqn{x_j} is given by
\deqn{
  H_j^2 = \frac{\frac{1}{n} \sum_{i = 1}^n\big[F(\mathbf{x}_i) - 
  \hat F_j(x_{ij}) - \hat F_{\setminus j}(\mathbf{x}_{i\setminus j})
  \big]^2}{\frac{1}{n} \sum_{i = 1}^n\big[F(\mathbf{x}_i)\big]^2}
}
(check \code{\link[=partial_dep]{partial_dep()}} for all definitions).

\strong{Remarks:}
\enumerate{
\item Partial dependence functions (and \eqn{F}) are all centered to
(possibly weighted) mean 0.
\item Partial dependence functions (and \eqn{F}) are evaluated over the data distribution.
This is different to partial dependence plots, where one uses a fixed grid.
\item Weighted versions follow by replacing all arithmetic means by corresponding
weighted means.
\item Multivariate predictions can be treated in a component-wise manner.
\item Due to (typically undesired) extrapolation effects of partial dependence functions,
depending on the model, values above 1 may occur.
\item \eqn{H^2_j = 0} means there are no interactions associated with \eqn{x_j}.
The higher the value, the more prediction variability comes from interactions
with \eqn{x_j}.
\item Since the denominator is the same for all features, the values of the test
statistics can be compared across features.
}
}
\section{Methods (by class)}{
\itemize{
\item \code{h2_overall(default)}: Default method of overall interaction strength.

\item \code{h2_overall(hstats)}: Overall interaction strength from "hstats" object.

}}
\examples{
# MODEL 1: Linear regression
fit <- lm(Sepal.Length ~ . + Petal.Width:Species, data = iris)
s <- hstats(fit, X = iris[, -1])
h2_overall(s)
plot(h2_overall(s))

# MODEL 2: Multi-response linear regression
fit <- lm(as.matrix(iris[, 1:2]) ~ Petal.Length + Petal.Width * Species, data = iris)
s <- hstats(fit, X = iris[, 3:5], verbose = FALSE)
plot(h2_overall(s, zero = FALSE))
}
\references{
Friedman, Jerome H., and Bogdan E. Popescu. \emph{"Predictive Learning via Rule Ensembles."}
The Annals of Applied Statistics 2, no. 3 (2008): 916-54.
}
\seealso{
\code{\link[=hstats]{hstats()}}, \code{\link[=h2]{h2()}}, \code{\link[=h2_pairwise]{h2_pairwise()}}, \code{\link[=h2_threeway]{h2_threeway()}}
}
