% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ivregimes_2.R
\name{ivregimes}
\alias{ivregimes}
\alias{coef.ivregimes}
\alias{vcov.ivregimes}
\alias{print.ivregimes}
\alias{summary.ivregimes}
\alias{print.summary.ivregimes}
\title{Estimation of spatial regimes}
\usage{
ivregimes(formula, data, rgv = NULL, vc = c("homoskedastic", "robust", "OGMM"))

\method{coef}{ivregimes}(object, ...)

\method{vcov}{ivregimes}(object, ...)

\method{print}{ivregimes}(x, digits = max(3, getOption("digits") - 3), ...)

\method{summary}{ivregimes}(object, ...)

\method{print}{summary.ivregimes}(x, digits = max(5, getOption("digits") - 3), ...)
}
\arguments{
\item{formula}{a symbolic description of the model of the form \code{y ~ x_f | x_v | h_f | h_v} where \code{y} is the dependent variable, \code{x_f} are the regressors that do not vary by regimes,  \code{x_v} are the regressors that vary by regimes, \code{h_f} are the fixed instruments and \code{h_v} are the instruments that vary by regimes.}

\item{data}{the data of class \code{data.frame}.}

\item{rgv}{an object of class \code{formula} to identify the regime variables}

\item{vc}{one of \code{c("homoskedastic", "robust", "OGMM")}. If \code{"OGMM"} an optimal weighted GMM is used to estimate the VC matrix.}

\item{object}{an object of class ivregime}

\item{...}{additional arguments}

\item{x}{an object of class ivregime}

\item{digits}{number of digits}
}
\value{
An object of class \code{ivregimes}. A \code{list} of five elements. The first element of the list contains the estimation results. The other elements are needed for printing the results.
}
\description{
Estimation of spatial regimes
}
\details{
The model estimated is:

\deqn{
y_{ij}= \mathbf{x_{ij,k}}\beta_j + \mathbf{Y_{ij,k}}\gamma_j + \epsilon
}
for i=1,..,n representing the sample observations, and j = 1,..., J representing
the  regimes
}
\examples{
data("natreg")
form   <- HR90  ~ 0 | MA90 + PS90 + RD90 + UE90 | 0 | MA90 + PS90 + RD90 + FH90 + FP89 + GI89
split  <- ~ REGIONS
mod <- ivregimes(formula = form, data = natreg, rgv = split, vc = "robust")
summary(mod)
mod1 <- ivregimes(formula = form, data = natreg, rgv = split, vc = "OGMM")
summary(mod1)
form1   <- HR90  ~ MA90 + PS90 |  RD90 + UE90 -1 | MA90 + PS90 | RD90 + FH90 + FP89 + GI89 -1
mod2 <- ivregimes(formula = form1, data = natreg, rgv = split, vc = "homoskedastic")
summary(mod2)

}
\author{
Gianfranco Piras and Mauricio Sarrias
}
