% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hsm.path.R
\name{lam.max.hsm}
\alias{lam.max.hsm}
\title{Computes the smallest lam value such that beta = 0.}
\usage{
lam.max.hsm(y, assign, w.assign)
}
\arguments{
\item{y}{Length-\code{p} vector used in proximal operator.}

\item{assign}{Matrix of \code{p} columns that gives the assignments of
variables over different path graphs. Each row of \code{assign} corresponds to
a path graph decomposed from DAG. Refer to \code{\link{paths}} for more details.}

\item{w.assign}{List of length \code{nrow(assign)}, for which
the \code{l}th element contains the weights corresponding to the
\code{l}th row of \code{assign} (the \code{l}th path graph). For
example, if the \code{l}th path graph is made up of three nodes indexed with
\code{{3, 4, 6, 8}}, \code{w.assign[[l]] = {w_3, w_4, w_6, w_8}}.
Refer to \code{\link{paths}} for more details.}
}
\description{
Computes \code{lammax}, the smallest value of lam for which \code{\link{hsm}}
gives a completely sparse solution.
}
\seealso{
\code{\link{hsm.path}}
}
