% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/sets.R
\name{get.term.adjacency.matrix}
\alias{get.term.adjacency.matrix}
\title{Get an adjacency for set of HPO terms}
\usage{
get.term.adjacency.matrix(hpo.terms, terms)
}
\arguments{
\item{hpo.terms}{R-Object representation of HPO}

\item{terms}{Character vector of HPO terms}
}
\value{
A logical matrix representing the directed adjacency matrix of \code{terms} based on DAG structure of HPO, whereby a TRUE entry signifies that the term corresponding to the column is a parent term of the term correspnding to the row.
}
\description{
Get an adjacency for set of HPO terms
}
\examples{
data(hpo.terms)
get.term.adjacency.matrix(hpo.terms, c("HP:0000118", "HP:0001873", "HP:0011877"))
}
\seealso{
\code{\link{get.term.pseudo.adjacency.matrix}}
}

