% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ruleheat.R
\name{ruleheat}
\alias{ruleheat}
\title{RuleHeatmap}
\usage{
ruleheat(model, k)
}
\arguments{
\item{model}{list containing a model of class "HorseRuleFit".}

\item{k}{number of most important rules to be shown in the RuleHeat plot.
library(MASS)
data(Boston)
# Split in train and test data
N = nrow(Boston)
train = sample(1:N, 400)
Xtrain = Boston[train,-14]
ytrain = Boston[train, 14]
Xtest = Boston[-train, -14]
ytest = Boston[-train, 14]

hrres = HorseRuleFit(X = Xtrain, y=ytrain,
                    thin=1, niter=200, burnin=10,
                    L=5, S=6, ensemble = "both", mix=0.3, ntree=100,
                    intercept=FALSE, linterms=1:13, ytransform = "log",
                    alpha=1, beta=2, linp = 1, restricted = 0)

#Create a ruleheat plot.
ruleheat(hrres = 10)}
}
\description{
Produces a heatmap that allows to identify what observations are covered by the most important decision rules. Details can be found in Nalenz & Villani (2017).
}
