% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sim_multvar.R
\name{sim_cat}
\alias{sim_cat}
\title{Simulate categorical data}
\usage{
sim_cat(.data = NULL, n_obs = NULL, n_groups, name = "group")
}
\arguments{
\item{.data}{An optional dataframe.  If a dataframe is supplied, simulated categorical data will be added to the dataframe. Either `.data` or `n_obs` must be supplied.}

\item{n_obs}{Total number of observations/rows to simulate if `.data` is not supplied.}

\item{n_groups}{How many groups or treatments to simulate.}

\item{name}{The column name for the grouping variable.  Defaults to "group".}
}
\value{
a tibble
}
\description{
This is a simple wrapper that creates a tibble of length `n_obs` with a single column `groups`.  It will warn if there are fewer than three replicates per group.
}
\details{
To-do:

- Make this optionally create multiple categorical variables as being nested or crossed or random
}
\examples{
df <- sim_cat(n_obs = 30, n_groups = 3)
}
\seealso{
\code{\link{sim_covar}}, \code{\link{sim_discr}}

Other multivariate normal functions: \code{\link{sim_covar}},
  \code{\link{sim_discr}}
}
\concept{multivariate normal functions}
