% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/con_iachan_holland.R
\name{con_iachan_holland}
\alias{con_iachan_holland}
\title{Congruence Index according to Iachan (1984)}
\usage{
con_iachan_holland(a, b)
}
\arguments{
\item{a}{a character vector with person Holland codes.}

\item{b}{a character vector with environment Holland codes.}
}
\value{
a numeric with value for congruence.
}
\description{
The function computes the congruence index according to Iachan (1984).
}
\details{
The function finds the congruence according to Iachan (1984) between the three-letter Holland-codes given in argument a, which is the person code, and argument b, which is the environment code. The Index is defined for three letters from the Holland code. The degree of congruence is output, according to its definition by Iachan (1984), as a reciprocal value of a distance. This means, for example, that a value of '28' is the result for a perfect fit !
}
\examples{
con_iachan_holland(a="RIA",b="SEC") # max. difference 
con_iachan_holland(a="RIA",b="RIA") # max. similarity
}
\references{
Holland, J.L. 1963. A theory of vocational choice. I. Vocational images and choice. \emph{Vocational Guidance Quarterly, 11}(4), 232–239.

Iachan, R. (1984). A measure of agreement for use with the Holland classification system. \emph{Journal of Vocational Behavior, 24} (2), 133–141.
}
\keyword{congruence}
