% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hglm.R
\name{hglm}
\alias{hglm}
\alias{holiglm}
\alias{hglm_seq}
\title{Fitting Holistic Generalized Linear Models}
\usage{
hglm(
  formula,
  family = gaussian(),
  data,
  constraints = NULL,
  weights = NULL,
  scaler = c("auto", "center_standardization", "center_minmax", "standardization",
    "minmax", "off"),
  scale_response = NULL,
  big_m = 100,
  solver = "auto",
  control = list(),
  dry_run = FALSE
)

holiglm(
  formula,
  family = gaussian(),
  data,
  constraints = NULL,
  weights = NULL,
  scaler = c("auto", "center_standardization", "center_minmax", "standardization",
    "minmax", "off"),
  scale_response = NULL,
  big_m = 100,
  solver = "auto",
  control = list(),
  dry_run = FALSE
)

hglm_seq(
  k_seq,
  formula,
  family = gaussian(),
  data,
  constraints = NULL,
  weights = NULL,
  scaler = c("auto", "center_standardization", "center_minmax", "standardization",
    "minmax", "off"),
  big_m = 100,
  solver = "auto",
  control = list()
)
}
\arguments{
\item{formula}{an object of class \code{"formula"} giving the symbolic description
of the model to be fitted.}

\item{family}{a description of the error distribution and link function to be used in the model.}

\item{data}{a \code{data.frame} or \code{matrix} giving the data for the estimation.}

\item{constraints}{a list of 'HGLM' constraints stored in a list of class \code{"lohglmc"}.
Use \code{NULL} to turn off constraints.}

\item{weights}{an optional vector of 'prior weights' to be used for the estimation.}

\item{scaler}{a character string giving the name of the scaling function (default is \code{"auto"})
to be employed for the covariates. This typically does not need to be changed.}

\item{scale_response}{a boolean whether the response shall be standardized or not. Can only
be used with family \code{gaussian()}. Default is \code{TRUE} for
family \code{gaussian()} and \code{FALSE} for other families.}

\item{big_m}{an upper bound for the coefficients, needed for the big-M constraint.
Required to inherit from \code{"hglmc"}. Currently constraints created by
\code{group_sparsity()}, \code{group_inout()},
\code{include()} and \code{group_equal()} use the big-M value specified here.}

\item{solver}{a character string giving the name of the solver to be used for the estimation.}

\item{control}{a list of control parameters passed to \code{ROI_solve}.}

\item{dry_run}{a logical; if \code{TRUE} the model is not fit but only constructed.}

\item{k_seq}{an integer vector giving the values of \code{k_max} for which the model
should be estimated.}
}
\value{
An object of class \code{"hglm"} inheriting from \code{"glm"}.
}
\description{
Fit a generalized linear model under holistic constraints.
}
\examples{
dat <- rhglm(100, c(1, 2, -3, 4, 5, -6))
hglm(y ~ ., constraints = NULL, data = dat)
# estimation without constraints
hglm(y ~ ., constraints = NULL, data = dat)
# estimation with an upper bound on the number of coefficients to be selected
hglm(y ~ ., constraints = k_max(3), data = dat)
# estimation without intercept
hglm(y ~ . - 1, data = dat)
}
