% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculate_toi.R
\name{calculate_toi}
\alias{calculate_toi}
\title{Calculate player time on ice}
\usage{
calculate_toi(pbp)
}
\arguments{
\item{pbp}{A tibble of play-by-play data, typically returned from either
\code{\link{load_pbp}} or \code{\link{scrape_game}}}
}
\value{
A tibble containing time on ice information for every skater in supplied pbp data
\describe{
\item{player_name}{String identifying player name}
\item{player_id}{Integer value of the NHL player ID}
\item{gp}{Games Played}
\item{toi}{String description of total time on ice in 'minutes:seconds'}
\item{mean_toi}{String description of average time on ice over all supplied games, in 'minutes:seconds'}
\item{toi_minutes}{Numeric total time on ice, in minutes}
\item{mean_toi_minutes}{Numeric average time on ice over all supplied games, in minutes}
}
}
\description{
A function to calculate individual skater time on ice for a provided
play-by-play data set
}
\examples{
\dontrun{
pbp_2022 <- load_pbp(2022)
skater_toi <- calculate_toi(pbp_2022)
}
}
