// Generated by rstantools.  Do not edit by hand.

/*
    historicalborrowlong is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    historicalborrowlong is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with historicalborrowlong.  If not, see <http://www.gnu.org/licenses/>.
*/
#ifndef MODELS_HPP
#define MODELS_HPP
#define STAN__SERVICES__COMMAND_HPP
#include <rstan/rstaninc.hpp>
// Code generated by Stan version 2.21.0
#include <stan/model/model_header.hpp>
namespace model_historicalborrowlong_namespace {
using std::istream;
using std::string;
using std::stringstream;
using std::vector;
using stan::io::dump;
using stan::math::lgamma;
using stan::model::prob_grad;
using namespace stan::math;
static int current_statement_begin__;
stan::io::program_reader prog_reader__() {
    stan::io::program_reader reader;
    reader.add_event(0, 0, "start", "model_historicalborrowlong");
    reader.add_event(265, 263, "end", "model_historicalborrowlong");
    return reader;
}
template <typename T0__, typename T1__>
Eigen::Matrix<typename boost::math::tools::promote_args<T0__, T1__>::type, 1, Eigen::Dynamic>
log_normal_kernel(const Eigen::Matrix<T0__, Eigen::Dynamic, Eigen::Dynamic>& cholesky,
                      const Eigen::Matrix<T1__, Eigen::Dynamic, Eigen::Dynamic>& epsilon, std::ostream* pstream__) {
    typedef typename boost::math::tools::promote_args<T0__, T1__>::type local_scalar_t__;
    typedef local_scalar_t__ fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
    int current_statement_begin__ = -1;
    try {
        current_statement_begin__ = 24;
        return stan::math::promote_scalar<fun_return_scalar_t__>(subtract(multiply(-(0.5), columns_dot_self(mdivide_left_tri_low(cholesky, epsilon))), sum(stan::math::log(diagonal(cholesky)))));
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}
struct log_normal_kernel_functor__ {
    template <typename T0__, typename T1__>
        Eigen::Matrix<typename boost::math::tools::promote_args<T0__, T1__>::type, 1, Eigen::Dynamic>
    operator()(const Eigen::Matrix<T0__, Eigen::Dynamic, Eigen::Dynamic>& cholesky,
                      const Eigen::Matrix<T1__, Eigen::Dynamic, Eigen::Dynamic>& epsilon, std::ostream* pstream__) const {
        return log_normal_kernel(cholesky, epsilon, pstream__);
    }
};
template <typename T0__>
Eigen::Matrix<typename boost::math::tools::promote_args<T0__>::type, Eigen::Dynamic, Eigen::Dynamic>
ar1_cholesky(const T0__& rho,
                 const int& n, std::ostream* pstream__) {
    typedef typename boost::math::tools::promote_args<T0__>::type local_scalar_t__;
    typedef local_scalar_t__ fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
    int current_statement_begin__ = -1;
    try {
        {
        current_statement_begin__ = 42;
        local_scalar_t__ scale(DUMMY_VAR__);
        (void) scale;  // dummy to suppress unused var warning
        stan::math::initialize(scale, DUMMY_VAR__);
        stan::math::fill(scale, DUMMY_VAR__);
        stan::math::assign(scale,stan::math::sqrt((1 - (rho * rho))));
        current_statement_begin__ = 43;
        validate_non_negative_index("out", "n", n);
        validate_non_negative_index("out", "n", n);
        Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, Eigen::Dynamic> out(n, n);
        stan::math::initialize(out, DUMMY_VAR__);
        stan::math::fill(out, DUMMY_VAR__);
        stan::math::assign(out,rep_matrix(0, n, n));
        current_statement_begin__ = 44;
        stan::model::assign(out, 
                    stan::model::cons_list(stan::model::index_uni(1), stan::model::cons_list(stan::model::index_uni(1), stan::model::nil_index_list())), 
                    1.0, 
                    "assigning variable out");
        current_statement_begin__ = 45;
        for (int i = 2; i <= n; ++i) {
            current_statement_begin__ = 46;
            stan::model::assign(out, 
                        stan::model::cons_list(stan::model::index_uni(i), stan::model::cons_list(stan::model::index_uni(1), stan::model::nil_index_list())), 
                        pow(rho, (i - 1)), 
                        "assigning variable out");
        }
        current_statement_begin__ = 48;
        for (int i = 2; i <= n; ++i) {
            current_statement_begin__ = 49;
            for (int j = 2; j <= i; ++j) {
                current_statement_begin__ = 50;
                stan::model::assign(out, 
                            stan::model::cons_list(stan::model::index_uni(i), stan::model::cons_list(stan::model::index_uni(j), stan::model::nil_index_list())), 
                            (scale * pow(rho, (i - j))), 
                            "assigning variable out");
            }
        }
        current_statement_begin__ = 53;
        return stan::math::promote_scalar<fun_return_scalar_t__>(out);
        }
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}
struct ar1_cholesky_functor__ {
    template <typename T0__>
        Eigen::Matrix<typename boost::math::tools::promote_args<T0__>::type, Eigen::Dynamic, Eigen::Dynamic>
    operator()(const T0__& rho,
                 const int& n, std::ostream* pstream__) const {
        return ar1_cholesky(rho, n, pstream__);
    }
};
#include <stan_meta_header.hpp>
class model_historicalborrowlong
  : public stan::model::model_base_crtp<model_historicalborrowlong> {
private:
        int model_type;
        int n_alpha;
        int n_mu;
        int n_tau;
        int n_delta;
        int n_beta;
        int n_observe;
        int n_missing;
        int n_patient;
        int n_rep;
        int n_study;
        int n_study_x_beta;
        int n_lambda_current;
        int n_lambda_historical;
        int n_rho_current;
        int n_rho_historical;
        std::vector<int> n_patient_study;
        std::vector<int> index_patient_study;
        std::vector<int> index_patient;
        double s_alpha;
        double s_mu;
        double s_tau;
        double s_beta;
        double s_delta;
        double s_sigma;
        double s_lambda;
        std::vector<int> missing;
        std::vector<int> count_missing;
        std::vector<int> study_index;
        std::vector<int> alpha_rep_index;
        std::vector<int> alpha_data_index;
        std::vector<int> delta_data_index;
        std::vector<int> x_beta_col_index;
        std::vector<int> x_beta_row_index;
        std::vector<int> x_beta_col_n;
        std::vector<int> x_beta_row_n;
        std::vector<int> study_patient;
        vector_d y;
        matrix_d x_alpha;
        matrix_d x_delta;
        matrix_d x_beta;
        int covariance_current;
        int covariance_historical;
        int covariance_unstructured;
        int covariance_ar1;
        int covariance_diagonal;
public:
    model_historicalborrowlong(stan::io::var_context& context__,
        std::ostream* pstream__ = 0)
        : model_base_crtp(0) {
        ctor_body(context__, 0, pstream__);
    }
    model_historicalborrowlong(stan::io::var_context& context__,
        unsigned int random_seed__,
        std::ostream* pstream__ = 0)
        : model_base_crtp(0) {
        ctor_body(context__, random_seed__, pstream__);
    }
    void ctor_body(stan::io::var_context& context__,
                   unsigned int random_seed__,
                   std::ostream* pstream__) {
        typedef double local_scalar_t__;
        boost::ecuyer1988 base_rng__ =
          stan::services::util::create_rng(random_seed__, 0);
        (void) base_rng__;  // suppress unused var warning
        current_statement_begin__ = -1;
        static const char* function__ = "model_historicalborrowlong_namespace::model_historicalborrowlong";
        (void) function__;  // dummy to suppress unused var warning
        size_t pos__;
        (void) pos__;  // dummy to suppress unused var warning
        std::vector<int> vals_i__;
        std::vector<double> vals_r__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
        try {
            // initialize data block variables from context__
            current_statement_begin__ = 57;
            context__.validate_dims("data initialization", "model_type", "int", context__.to_vec());
            model_type = int(0);
            vals_i__ = context__.vals_i("model_type");
            pos__ = 0;
            model_type = vals_i__[pos__++];
            check_greater_or_equal(function__, "model_type", model_type, 1);
            check_less_or_equal(function__, "model_type", model_type, 3);
            current_statement_begin__ = 58;
            context__.validate_dims("data initialization", "n_alpha", "int", context__.to_vec());
            n_alpha = int(0);
            vals_i__ = context__.vals_i("n_alpha");
            pos__ = 0;
            n_alpha = vals_i__[pos__++];
            check_greater_or_equal(function__, "n_alpha", n_alpha, 0);
            current_statement_begin__ = 59;
            context__.validate_dims("data initialization", "n_mu", "int", context__.to_vec());
            n_mu = int(0);
            vals_i__ = context__.vals_i("n_mu");
            pos__ = 0;
            n_mu = vals_i__[pos__++];
            check_greater_or_equal(function__, "n_mu", n_mu, 0);
            current_statement_begin__ = 60;
            context__.validate_dims("data initialization", "n_tau", "int", context__.to_vec());
            n_tau = int(0);
            vals_i__ = context__.vals_i("n_tau");
            pos__ = 0;
            n_tau = vals_i__[pos__++];
            check_greater_or_equal(function__, "n_tau", n_tau, 0);
            current_statement_begin__ = 61;
            context__.validate_dims("data initialization", "n_delta", "int", context__.to_vec());
            n_delta = int(0);
            vals_i__ = context__.vals_i("n_delta");
            pos__ = 0;
            n_delta = vals_i__[pos__++];
            check_greater_or_equal(function__, "n_delta", n_delta, 0);
            current_statement_begin__ = 62;
            context__.validate_dims("data initialization", "n_beta", "int", context__.to_vec());
            n_beta = int(0);
            vals_i__ = context__.vals_i("n_beta");
            pos__ = 0;
            n_beta = vals_i__[pos__++];
            check_greater_or_equal(function__, "n_beta", n_beta, 0);
            current_statement_begin__ = 63;
            context__.validate_dims("data initialization", "n_observe", "int", context__.to_vec());
            n_observe = int(0);
            vals_i__ = context__.vals_i("n_observe");
            pos__ = 0;
            n_observe = vals_i__[pos__++];
            check_greater_or_equal(function__, "n_observe", n_observe, 0);
            current_statement_begin__ = 64;
            context__.validate_dims("data initialization", "n_missing", "int", context__.to_vec());
            n_missing = int(0);
            vals_i__ = context__.vals_i("n_missing");
            pos__ = 0;
            n_missing = vals_i__[pos__++];
            check_greater_or_equal(function__, "n_missing", n_missing, 0);
            current_statement_begin__ = 65;
            context__.validate_dims("data initialization", "n_patient", "int", context__.to_vec());
            n_patient = int(0);
            vals_i__ = context__.vals_i("n_patient");
            pos__ = 0;
            n_patient = vals_i__[pos__++];
            check_greater_or_equal(function__, "n_patient", n_patient, 0);
            current_statement_begin__ = 66;
            context__.validate_dims("data initialization", "n_rep", "int", context__.to_vec());
            n_rep = int(0);
            vals_i__ = context__.vals_i("n_rep");
            pos__ = 0;
            n_rep = vals_i__[pos__++];
            check_greater_or_equal(function__, "n_rep", n_rep, 0);
            current_statement_begin__ = 67;
            context__.validate_dims("data initialization", "n_study", "int", context__.to_vec());
            n_study = int(0);
            vals_i__ = context__.vals_i("n_study");
            pos__ = 0;
            n_study = vals_i__[pos__++];
            check_greater_or_equal(function__, "n_study", n_study, 0);
            current_statement_begin__ = 68;
            context__.validate_dims("data initialization", "n_study_x_beta", "int", context__.to_vec());
            n_study_x_beta = int(0);
            vals_i__ = context__.vals_i("n_study_x_beta");
            pos__ = 0;
            n_study_x_beta = vals_i__[pos__++];
            check_greater_or_equal(function__, "n_study_x_beta", n_study_x_beta, 0);
            current_statement_begin__ = 69;
            context__.validate_dims("data initialization", "n_lambda_current", "int", context__.to_vec());
            n_lambda_current = int(0);
            vals_i__ = context__.vals_i("n_lambda_current");
            pos__ = 0;
            n_lambda_current = vals_i__[pos__++];
            check_greater_or_equal(function__, "n_lambda_current", n_lambda_current, 0);
            current_statement_begin__ = 70;
            context__.validate_dims("data initialization", "n_lambda_historical", "int", context__.to_vec());
            n_lambda_historical = int(0);
            vals_i__ = context__.vals_i("n_lambda_historical");
            pos__ = 0;
            n_lambda_historical = vals_i__[pos__++];
            check_greater_or_equal(function__, "n_lambda_historical", n_lambda_historical, 0);
            current_statement_begin__ = 71;
            context__.validate_dims("data initialization", "n_rho_current", "int", context__.to_vec());
            n_rho_current = int(0);
            vals_i__ = context__.vals_i("n_rho_current");
            pos__ = 0;
            n_rho_current = vals_i__[pos__++];
            check_greater_or_equal(function__, "n_rho_current", n_rho_current, 0);
            current_statement_begin__ = 72;
            context__.validate_dims("data initialization", "n_rho_historical", "int", context__.to_vec());
            n_rho_historical = int(0);
            vals_i__ = context__.vals_i("n_rho_historical");
            pos__ = 0;
            n_rho_historical = vals_i__[pos__++];
            check_greater_or_equal(function__, "n_rho_historical", n_rho_historical, 0);
            current_statement_begin__ = 73;
            validate_non_negative_index("n_patient_study", "n_study", n_study);
            context__.validate_dims("data initialization", "n_patient_study", "int", context__.to_vec(n_study));
            n_patient_study = std::vector<int>(n_study, int(0));
            vals_i__ = context__.vals_i("n_patient_study");
            pos__ = 0;
            size_t n_patient_study_k_0_max__ = n_study;
            for (size_t k_0__ = 0; k_0__ < n_patient_study_k_0_max__; ++k_0__) {
                n_patient_study[k_0__] = vals_i__[pos__++];
            }
            size_t n_patient_study_i_0_max__ = n_study;
            for (size_t i_0__ = 0; i_0__ < n_patient_study_i_0_max__; ++i_0__) {
                check_greater_or_equal(function__, "n_patient_study[i_0__]", n_patient_study[i_0__], 0);
            }
            current_statement_begin__ = 74;
            validate_non_negative_index("index_patient_study", "n_study", n_study);
            context__.validate_dims("data initialization", "index_patient_study", "int", context__.to_vec(n_study));
            index_patient_study = std::vector<int>(n_study, int(0));
            vals_i__ = context__.vals_i("index_patient_study");
            pos__ = 0;
            size_t index_patient_study_k_0_max__ = n_study;
            for (size_t k_0__ = 0; k_0__ < index_patient_study_k_0_max__; ++k_0__) {
                index_patient_study[k_0__] = vals_i__[pos__++];
            }
            size_t index_patient_study_i_0_max__ = n_study;
            for (size_t i_0__ = 0; i_0__ < index_patient_study_i_0_max__; ++i_0__) {
                check_greater_or_equal(function__, "index_patient_study[i_0__]", index_patient_study[i_0__], 0);
            }
            current_statement_begin__ = 75;
            validate_non_negative_index("index_patient", "n_observe", n_observe);
            context__.validate_dims("data initialization", "index_patient", "int", context__.to_vec(n_observe));
            index_patient = std::vector<int>(n_observe, int(0));
            vals_i__ = context__.vals_i("index_patient");
            pos__ = 0;
            size_t index_patient_k_0_max__ = n_observe;
            for (size_t k_0__ = 0; k_0__ < index_patient_k_0_max__; ++k_0__) {
                index_patient[k_0__] = vals_i__[pos__++];
            }
            size_t index_patient_i_0_max__ = n_observe;
            for (size_t i_0__ = 0; i_0__ < index_patient_i_0_max__; ++i_0__) {
                check_greater_or_equal(function__, "index_patient[i_0__]", index_patient[i_0__], 0);
            }
            current_statement_begin__ = 76;
            context__.validate_dims("data initialization", "s_alpha", "double", context__.to_vec());
            s_alpha = double(0);
            vals_r__ = context__.vals_r("s_alpha");
            pos__ = 0;
            s_alpha = vals_r__[pos__++];
            check_greater_or_equal(function__, "s_alpha", s_alpha, 0);
            current_statement_begin__ = 77;
            context__.validate_dims("data initialization", "s_mu", "double", context__.to_vec());
            s_mu = double(0);
            vals_r__ = context__.vals_r("s_mu");
            pos__ = 0;
            s_mu = vals_r__[pos__++];
            check_greater_or_equal(function__, "s_mu", s_mu, 0);
            current_statement_begin__ = 78;
            context__.validate_dims("data initialization", "s_tau", "double", context__.to_vec());
            s_tau = double(0);
            vals_r__ = context__.vals_r("s_tau");
            pos__ = 0;
            s_tau = vals_r__[pos__++];
            check_greater_or_equal(function__, "s_tau", s_tau, 0);
            current_statement_begin__ = 79;
            context__.validate_dims("data initialization", "s_beta", "double", context__.to_vec());
            s_beta = double(0);
            vals_r__ = context__.vals_r("s_beta");
            pos__ = 0;
            s_beta = vals_r__[pos__++];
            check_greater_or_equal(function__, "s_beta", s_beta, 0);
            current_statement_begin__ = 80;
            context__.validate_dims("data initialization", "s_delta", "double", context__.to_vec());
            s_delta = double(0);
            vals_r__ = context__.vals_r("s_delta");
            pos__ = 0;
            s_delta = vals_r__[pos__++];
            check_greater_or_equal(function__, "s_delta", s_delta, 0);
            current_statement_begin__ = 81;
            context__.validate_dims("data initialization", "s_sigma", "double", context__.to_vec());
            s_sigma = double(0);
            vals_r__ = context__.vals_r("s_sigma");
            pos__ = 0;
            s_sigma = vals_r__[pos__++];
            check_greater_or_equal(function__, "s_sigma", s_sigma, 0);
            current_statement_begin__ = 82;
            context__.validate_dims("data initialization", "s_lambda", "double", context__.to_vec());
            s_lambda = double(0);
            vals_r__ = context__.vals_r("s_lambda");
            pos__ = 0;
            s_lambda = vals_r__[pos__++];
            check_greater_or_equal(function__, "s_lambda", s_lambda, 0);
            current_statement_begin__ = 83;
            validate_non_negative_index("missing", "n_observe", n_observe);
            context__.validate_dims("data initialization", "missing", "int", context__.to_vec(n_observe));
            missing = std::vector<int>(n_observe, int(0));
            vals_i__ = context__.vals_i("missing");
            pos__ = 0;
            size_t missing_k_0_max__ = n_observe;
            for (size_t k_0__ = 0; k_0__ < missing_k_0_max__; ++k_0__) {
                missing[k_0__] = vals_i__[pos__++];
            }
            size_t missing_i_0_max__ = n_observe;
            for (size_t i_0__ = 0; i_0__ < missing_i_0_max__; ++i_0__) {
                check_greater_or_equal(function__, "missing[i_0__]", missing[i_0__], 0);
            }
            current_statement_begin__ = 84;
            validate_non_negative_index("count_missing", "n_observe", n_observe);
            context__.validate_dims("data initialization", "count_missing", "int", context__.to_vec(n_observe));
            count_missing = std::vector<int>(n_observe, int(0));
            vals_i__ = context__.vals_i("count_missing");
            pos__ = 0;
            size_t count_missing_k_0_max__ = n_observe;
            for (size_t k_0__ = 0; k_0__ < count_missing_k_0_max__; ++k_0__) {
                count_missing[k_0__] = vals_i__[pos__++];
            }
            size_t count_missing_i_0_max__ = n_observe;
            for (size_t i_0__ = 0; i_0__ < count_missing_i_0_max__; ++i_0__) {
                check_greater_or_equal(function__, "count_missing[i_0__]", count_missing[i_0__], 0);
            }
            current_statement_begin__ = 85;
            validate_non_negative_index("study_index", "n_observe", n_observe);
            context__.validate_dims("data initialization", "study_index", "int", context__.to_vec(n_observe));
            study_index = std::vector<int>(n_observe, int(0));
            vals_i__ = context__.vals_i("study_index");
            pos__ = 0;
            size_t study_index_k_0_max__ = n_observe;
            for (size_t k_0__ = 0; k_0__ < study_index_k_0_max__; ++k_0__) {
                study_index[k_0__] = vals_i__[pos__++];
            }
            size_t study_index_i_0_max__ = n_observe;
            for (size_t i_0__ = 0; i_0__ < study_index_i_0_max__; ++i_0__) {
                check_greater_or_equal(function__, "study_index[i_0__]", study_index[i_0__], 0);
            }
            current_statement_begin__ = 86;
            validate_non_negative_index("alpha_rep_index", "n_alpha", n_alpha);
            context__.validate_dims("data initialization", "alpha_rep_index", "int", context__.to_vec(n_alpha));
            alpha_rep_index = std::vector<int>(n_alpha, int(0));
            vals_i__ = context__.vals_i("alpha_rep_index");
            pos__ = 0;
            size_t alpha_rep_index_k_0_max__ = n_alpha;
            for (size_t k_0__ = 0; k_0__ < alpha_rep_index_k_0_max__; ++k_0__) {
                alpha_rep_index[k_0__] = vals_i__[pos__++];
            }
            size_t alpha_rep_index_i_0_max__ = n_alpha;
            for (size_t i_0__ = 0; i_0__ < alpha_rep_index_i_0_max__; ++i_0__) {
                check_greater_or_equal(function__, "alpha_rep_index[i_0__]", alpha_rep_index[i_0__], 0);
            }
            current_statement_begin__ = 87;
            validate_non_negative_index("alpha_data_index", "n_observe", n_observe);
            context__.validate_dims("data initialization", "alpha_data_index", "int", context__.to_vec(n_observe));
            alpha_data_index = std::vector<int>(n_observe, int(0));
            vals_i__ = context__.vals_i("alpha_data_index");
            pos__ = 0;
            size_t alpha_data_index_k_0_max__ = n_observe;
            for (size_t k_0__ = 0; k_0__ < alpha_data_index_k_0_max__; ++k_0__) {
                alpha_data_index[k_0__] = vals_i__[pos__++];
            }
            size_t alpha_data_index_i_0_max__ = n_observe;
            for (size_t i_0__ = 0; i_0__ < alpha_data_index_i_0_max__; ++i_0__) {
                check_greater_or_equal(function__, "alpha_data_index[i_0__]", alpha_data_index[i_0__], 0);
            }
            current_statement_begin__ = 88;
            validate_non_negative_index("delta_data_index", "n_observe", n_observe);
            context__.validate_dims("data initialization", "delta_data_index", "int", context__.to_vec(n_observe));
            delta_data_index = std::vector<int>(n_observe, int(0));
            vals_i__ = context__.vals_i("delta_data_index");
            pos__ = 0;
            size_t delta_data_index_k_0_max__ = n_observe;
            for (size_t k_0__ = 0; k_0__ < delta_data_index_k_0_max__; ++k_0__) {
                delta_data_index[k_0__] = vals_i__[pos__++];
            }
            size_t delta_data_index_i_0_max__ = n_observe;
            for (size_t i_0__ = 0; i_0__ < delta_data_index_i_0_max__; ++i_0__) {
                check_greater_or_equal(function__, "delta_data_index[i_0__]", delta_data_index[i_0__], 0);
            }
            current_statement_begin__ = 89;
            validate_non_negative_index("x_beta_col_index", "n_study_x_beta", n_study_x_beta);
            context__.validate_dims("data initialization", "x_beta_col_index", "int", context__.to_vec(n_study_x_beta));
            x_beta_col_index = std::vector<int>(n_study_x_beta, int(0));
            vals_i__ = context__.vals_i("x_beta_col_index");
            pos__ = 0;
            size_t x_beta_col_index_k_0_max__ = n_study_x_beta;
            for (size_t k_0__ = 0; k_0__ < x_beta_col_index_k_0_max__; ++k_0__) {
                x_beta_col_index[k_0__] = vals_i__[pos__++];
            }
            size_t x_beta_col_index_i_0_max__ = n_study_x_beta;
            for (size_t i_0__ = 0; i_0__ < x_beta_col_index_i_0_max__; ++i_0__) {
                check_greater_or_equal(function__, "x_beta_col_index[i_0__]", x_beta_col_index[i_0__], 0);
            }
            current_statement_begin__ = 90;
            validate_non_negative_index("x_beta_row_index", "n_study_x_beta", n_study_x_beta);
            context__.validate_dims("data initialization", "x_beta_row_index", "int", context__.to_vec(n_study_x_beta));
            x_beta_row_index = std::vector<int>(n_study_x_beta, int(0));
            vals_i__ = context__.vals_i("x_beta_row_index");
            pos__ = 0;
            size_t x_beta_row_index_k_0_max__ = n_study_x_beta;
            for (size_t k_0__ = 0; k_0__ < x_beta_row_index_k_0_max__; ++k_0__) {
                x_beta_row_index[k_0__] = vals_i__[pos__++];
            }
            size_t x_beta_row_index_i_0_max__ = n_study_x_beta;
            for (size_t i_0__ = 0; i_0__ < x_beta_row_index_i_0_max__; ++i_0__) {
                check_greater_or_equal(function__, "x_beta_row_index[i_0__]", x_beta_row_index[i_0__], 0);
            }
            current_statement_begin__ = 91;
            validate_non_negative_index("x_beta_col_n", "n_study_x_beta", n_study_x_beta);
            context__.validate_dims("data initialization", "x_beta_col_n", "int", context__.to_vec(n_study_x_beta));
            x_beta_col_n = std::vector<int>(n_study_x_beta, int(0));
            vals_i__ = context__.vals_i("x_beta_col_n");
            pos__ = 0;
            size_t x_beta_col_n_k_0_max__ = n_study_x_beta;
            for (size_t k_0__ = 0; k_0__ < x_beta_col_n_k_0_max__; ++k_0__) {
                x_beta_col_n[k_0__] = vals_i__[pos__++];
            }
            size_t x_beta_col_n_i_0_max__ = n_study_x_beta;
            for (size_t i_0__ = 0; i_0__ < x_beta_col_n_i_0_max__; ++i_0__) {
                check_greater_or_equal(function__, "x_beta_col_n[i_0__]", x_beta_col_n[i_0__], 0);
            }
            current_statement_begin__ = 92;
            validate_non_negative_index("x_beta_row_n", "n_study_x_beta", n_study_x_beta);
            context__.validate_dims("data initialization", "x_beta_row_n", "int", context__.to_vec(n_study_x_beta));
            x_beta_row_n = std::vector<int>(n_study_x_beta, int(0));
            vals_i__ = context__.vals_i("x_beta_row_n");
            pos__ = 0;
            size_t x_beta_row_n_k_0_max__ = n_study_x_beta;
            for (size_t k_0__ = 0; k_0__ < x_beta_row_n_k_0_max__; ++k_0__) {
                x_beta_row_n[k_0__] = vals_i__[pos__++];
            }
            size_t x_beta_row_n_i_0_max__ = n_study_x_beta;
            for (size_t i_0__ = 0; i_0__ < x_beta_row_n_i_0_max__; ++i_0__) {
                check_greater_or_equal(function__, "x_beta_row_n[i_0__]", x_beta_row_n[i_0__], 0);
            }
            current_statement_begin__ = 93;
            validate_non_negative_index("study_patient", "n_patient", n_patient);
            context__.validate_dims("data initialization", "study_patient", "int", context__.to_vec(n_patient));
            study_patient = std::vector<int>(n_patient, int(0));
            vals_i__ = context__.vals_i("study_patient");
            pos__ = 0;
            size_t study_patient_k_0_max__ = n_patient;
            for (size_t k_0__ = 0; k_0__ < study_patient_k_0_max__; ++k_0__) {
                study_patient[k_0__] = vals_i__[pos__++];
            }
            size_t study_patient_i_0_max__ = n_patient;
            for (size_t i_0__ = 0; i_0__ < study_patient_i_0_max__; ++i_0__) {
                check_greater_or_equal(function__, "study_patient[i_0__]", study_patient[i_0__], 0);
                check_less_or_equal(function__, "study_patient[i_0__]", study_patient[i_0__], n_patient);
            }
            current_statement_begin__ = 94;
            validate_non_negative_index("y", "n_observe", n_observe);
            context__.validate_dims("data initialization", "y", "vector_d", context__.to_vec(n_observe));
            y = Eigen::Matrix<double, Eigen::Dynamic, 1>(n_observe);
            vals_r__ = context__.vals_r("y");
            pos__ = 0;
            size_t y_j_1_max__ = n_observe;
            for (size_t j_1__ = 0; j_1__ < y_j_1_max__; ++j_1__) {
                y(j_1__) = vals_r__[pos__++];
            }
            current_statement_begin__ = 95;
            validate_non_negative_index("x_alpha", "n_observe", n_observe);
            validate_non_negative_index("x_alpha", "n_alpha", n_alpha);
            context__.validate_dims("data initialization", "x_alpha", "matrix_d", context__.to_vec(n_observe,n_alpha));
            x_alpha = Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic>(n_observe, n_alpha);
            vals_r__ = context__.vals_r("x_alpha");
            pos__ = 0;
            size_t x_alpha_j_2_max__ = n_alpha;
            size_t x_alpha_j_1_max__ = n_observe;
            for (size_t j_2__ = 0; j_2__ < x_alpha_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < x_alpha_j_1_max__; ++j_1__) {
                    x_alpha(j_1__, j_2__) = vals_r__[pos__++];
                }
            }
            current_statement_begin__ = 96;
            validate_non_negative_index("x_delta", "n_observe", n_observe);
            validate_non_negative_index("x_delta", "n_delta", n_delta);
            context__.validate_dims("data initialization", "x_delta", "matrix_d", context__.to_vec(n_observe,n_delta));
            x_delta = Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic>(n_observe, n_delta);
            vals_r__ = context__.vals_r("x_delta");
            pos__ = 0;
            size_t x_delta_j_2_max__ = n_delta;
            size_t x_delta_j_1_max__ = n_observe;
            for (size_t j_2__ = 0; j_2__ < x_delta_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < x_delta_j_1_max__; ++j_1__) {
                    x_delta(j_1__, j_2__) = vals_r__[pos__++];
                }
            }
            current_statement_begin__ = 97;
            validate_non_negative_index("x_beta", "n_beta", n_beta);
            validate_non_negative_index("x_beta", "n_patient", n_patient);
            context__.validate_dims("data initialization", "x_beta", "matrix_d", context__.to_vec(n_beta,n_patient));
            x_beta = Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic>(n_beta, n_patient);
            vals_r__ = context__.vals_r("x_beta");
            pos__ = 0;
            size_t x_beta_j_2_max__ = n_patient;
            size_t x_beta_j_1_max__ = n_beta;
            for (size_t j_2__ = 0; j_2__ < x_beta_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < x_beta_j_1_max__; ++j_1__) {
                    x_beta(j_1__, j_2__) = vals_r__[pos__++];
                }
            }
            current_statement_begin__ = 98;
            context__.validate_dims("data initialization", "covariance_current", "int", context__.to_vec());
            covariance_current = int(0);
            vals_i__ = context__.vals_i("covariance_current");
            pos__ = 0;
            covariance_current = vals_i__[pos__++];
            check_greater_or_equal(function__, "covariance_current", covariance_current, 1);
            check_less_or_equal(function__, "covariance_current", covariance_current, 3);
            current_statement_begin__ = 99;
            context__.validate_dims("data initialization", "covariance_historical", "int", context__.to_vec());
            covariance_historical = int(0);
            vals_i__ = context__.vals_i("covariance_historical");
            pos__ = 0;
            covariance_historical = vals_i__[pos__++];
            check_greater_or_equal(function__, "covariance_historical", covariance_historical, 1);
            check_less_or_equal(function__, "covariance_historical", covariance_historical, 3);
            current_statement_begin__ = 100;
            context__.validate_dims("data initialization", "covariance_unstructured", "int", context__.to_vec());
            covariance_unstructured = int(0);
            vals_i__ = context__.vals_i("covariance_unstructured");
            pos__ = 0;
            covariance_unstructured = vals_i__[pos__++];
            current_statement_begin__ = 101;
            context__.validate_dims("data initialization", "covariance_ar1", "int", context__.to_vec());
            covariance_ar1 = int(0);
            vals_i__ = context__.vals_i("covariance_ar1");
            pos__ = 0;
            covariance_ar1 = vals_i__[pos__++];
            current_statement_begin__ = 102;
            context__.validate_dims("data initialization", "covariance_diagonal", "int", context__.to_vec());
            covariance_diagonal = int(0);
            vals_i__ = context__.vals_i("covariance_diagonal");
            pos__ = 0;
            covariance_diagonal = vals_i__[pos__++];
            // initialize transformed data variables
            // execute transformed data statements
            // validate transformed data
            // validate, set parameter ranges
            num_params_r__ = 0U;
            param_ranges_i__.clear();
            current_statement_begin__ = 105;
            validate_non_negative_index("y_missing", "n_missing", n_missing);
            num_params_r__ += n_missing;
            current_statement_begin__ = 106;
            validate_non_negative_index("alpha_raw", "n_alpha", n_alpha);
            num_params_r__ += n_alpha;
            current_statement_begin__ = 107;
            validate_non_negative_index("mu", "n_mu", n_mu);
            num_params_r__ += n_mu;
            current_statement_begin__ = 108;
            validate_non_negative_index("tau", "n_tau", n_tau);
            num_params_r__ += n_tau;
            current_statement_begin__ = 109;
            validate_non_negative_index("delta", "n_delta", n_delta);
            num_params_r__ += n_delta;
            current_statement_begin__ = 110;
            validate_non_negative_index("beta", "n_beta", n_beta);
            num_params_r__ += n_beta;
            current_statement_begin__ = 111;
            validate_non_negative_index("sigma", "n_rep", n_rep);
            validate_non_negative_index("sigma", "n_study", n_study);
            num_params_r__ += (n_rep * n_study);
            current_statement_begin__ = 112;
            validate_non_negative_index("lambda_current", "n_rep", n_rep);
            validate_non_negative_index("lambda_current", "n_rep", n_rep);
            validate_non_negative_index("lambda_current", "n_lambda_current", n_lambda_current);
            num_params_r__ += (((n_rep * (n_rep - 1)) / 2) * n_lambda_current);
            current_statement_begin__ = 113;
            validate_non_negative_index("lambda_historical", "n_rep", n_rep);
            validate_non_negative_index("lambda_historical", "n_rep", n_rep);
            validate_non_negative_index("lambda_historical", "n_lambda_historical", n_lambda_historical);
            num_params_r__ += (((n_rep * (n_rep - 1)) / 2) * n_lambda_historical);
            current_statement_begin__ = 114;
            validate_non_negative_index("rho_current", "n_rho_current", n_rho_current);
            num_params_r__ += n_rho_current;
            current_statement_begin__ = 115;
            validate_non_negative_index("rho_historical", "n_rho_historical", n_rho_historical);
            num_params_r__ += n_rho_historical;
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
    }
    ~model_historicalborrowlong() { }
    void transform_inits(const stan::io::var_context& context__,
                         std::vector<int>& params_i__,
                         std::vector<double>& params_r__,
                         std::ostream* pstream__) const {
        typedef double local_scalar_t__;
        stan::io::writer<double> writer__(params_r__, params_i__);
        size_t pos__;
        (void) pos__; // dummy call to supress warning
        std::vector<double> vals_r__;
        std::vector<int> vals_i__;
        current_statement_begin__ = 105;
        if (!(context__.contains_r("y_missing")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable y_missing missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("y_missing");
        pos__ = 0U;
        validate_non_negative_index("y_missing", "n_missing", n_missing);
        context__.validate_dims("parameter initialization", "y_missing", "vector_d", context__.to_vec(n_missing));
        Eigen::Matrix<double, Eigen::Dynamic, 1> y_missing(n_missing);
        size_t y_missing_j_1_max__ = n_missing;
        for (size_t j_1__ = 0; j_1__ < y_missing_j_1_max__; ++j_1__) {
            y_missing(j_1__) = vals_r__[pos__++];
        }
        try {
            writer__.vector_unconstrain(y_missing);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable y_missing: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 106;
        if (!(context__.contains_r("alpha_raw")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable alpha_raw missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("alpha_raw");
        pos__ = 0U;
        validate_non_negative_index("alpha_raw", "n_alpha", n_alpha);
        context__.validate_dims("parameter initialization", "alpha_raw", "vector_d", context__.to_vec(n_alpha));
        Eigen::Matrix<double, Eigen::Dynamic, 1> alpha_raw(n_alpha);
        size_t alpha_raw_j_1_max__ = n_alpha;
        for (size_t j_1__ = 0; j_1__ < alpha_raw_j_1_max__; ++j_1__) {
            alpha_raw(j_1__) = vals_r__[pos__++];
        }
        try {
            writer__.vector_unconstrain(alpha_raw);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable alpha_raw: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 107;
        if (!(context__.contains_r("mu")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable mu missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("mu");
        pos__ = 0U;
        validate_non_negative_index("mu", "n_mu", n_mu);
        context__.validate_dims("parameter initialization", "mu", "vector_d", context__.to_vec(n_mu));
        Eigen::Matrix<double, Eigen::Dynamic, 1> mu(n_mu);
        size_t mu_j_1_max__ = n_mu;
        for (size_t j_1__ = 0; j_1__ < mu_j_1_max__; ++j_1__) {
            mu(j_1__) = vals_r__[pos__++];
        }
        try {
            writer__.vector_unconstrain(mu);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable mu: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 108;
        if (!(context__.contains_r("tau")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable tau missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("tau");
        pos__ = 0U;
        validate_non_negative_index("tau", "n_tau", n_tau);
        context__.validate_dims("parameter initialization", "tau", "vector_d", context__.to_vec(n_tau));
        Eigen::Matrix<double, Eigen::Dynamic, 1> tau(n_tau);
        size_t tau_j_1_max__ = n_tau;
        for (size_t j_1__ = 0; j_1__ < tau_j_1_max__; ++j_1__) {
            tau(j_1__) = vals_r__[pos__++];
        }
        try {
            writer__.vector_lub_unconstrain(0, s_tau, tau);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable tau: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 109;
        if (!(context__.contains_r("delta")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable delta missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("delta");
        pos__ = 0U;
        validate_non_negative_index("delta", "n_delta", n_delta);
        context__.validate_dims("parameter initialization", "delta", "vector_d", context__.to_vec(n_delta));
        Eigen::Matrix<double, Eigen::Dynamic, 1> delta(n_delta);
        size_t delta_j_1_max__ = n_delta;
        for (size_t j_1__ = 0; j_1__ < delta_j_1_max__; ++j_1__) {
            delta(j_1__) = vals_r__[pos__++];
        }
        try {
            writer__.vector_unconstrain(delta);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable delta: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 110;
        if (!(context__.contains_r("beta")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable beta missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("beta");
        pos__ = 0U;
        validate_non_negative_index("beta", "n_beta", n_beta);
        context__.validate_dims("parameter initialization", "beta", "vector_d", context__.to_vec(n_beta));
        Eigen::Matrix<double, Eigen::Dynamic, 1> beta(n_beta);
        size_t beta_j_1_max__ = n_beta;
        for (size_t j_1__ = 0; j_1__ < beta_j_1_max__; ++j_1__) {
            beta(j_1__) = vals_r__[pos__++];
        }
        try {
            writer__.vector_unconstrain(beta);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable beta: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 111;
        if (!(context__.contains_r("sigma")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable sigma missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("sigma");
        pos__ = 0U;
        validate_non_negative_index("sigma", "n_rep", n_rep);
        validate_non_negative_index("sigma", "n_study", n_study);
        context__.validate_dims("parameter initialization", "sigma", "vector_d", context__.to_vec(n_study,n_rep));
        std::vector<Eigen::Matrix<double, Eigen::Dynamic, 1> > sigma(n_study, Eigen::Matrix<double, Eigen::Dynamic, 1>(n_rep));
        size_t sigma_j_1_max__ = n_rep;
        size_t sigma_k_0_max__ = n_study;
        for (size_t j_1__ = 0; j_1__ < sigma_j_1_max__; ++j_1__) {
            for (size_t k_0__ = 0; k_0__ < sigma_k_0_max__; ++k_0__) {
                sigma[k_0__](j_1__) = vals_r__[pos__++];
            }
        }
        size_t sigma_i_0_max__ = n_study;
        for (size_t i_0__ = 0; i_0__ < sigma_i_0_max__; ++i_0__) {
            try {
                writer__.vector_lub_unconstrain(0, s_sigma, sigma[i_0__]);
            } catch (const std::exception& e) {
                stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable sigma: ") + e.what()), current_statement_begin__, prog_reader__());
            }
        }
        current_statement_begin__ = 112;
        if (!(context__.contains_r("lambda_current")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable lambda_current missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("lambda_current");
        pos__ = 0U;
        validate_non_negative_index("lambda_current", "n_rep", n_rep);
        validate_non_negative_index("lambda_current", "n_rep", n_rep);
        validate_non_negative_index("lambda_current", "n_lambda_current", n_lambda_current);
        context__.validate_dims("parameter initialization", "lambda_current", "matrix_d", context__.to_vec(n_lambda_current,n_rep,n_rep));
        std::vector<Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic> > lambda_current(n_lambda_current, Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic>(n_rep, n_rep));
        size_t lambda_current_j_2_max__ = n_rep;
        size_t lambda_current_j_1_max__ = n_rep;
        size_t lambda_current_k_0_max__ = n_lambda_current;
        for (size_t j_2__ = 0; j_2__ < lambda_current_j_2_max__; ++j_2__) {
            for (size_t j_1__ = 0; j_1__ < lambda_current_j_1_max__; ++j_1__) {
                for (size_t k_0__ = 0; k_0__ < lambda_current_k_0_max__; ++k_0__) {
                    lambda_current[k_0__](j_1__, j_2__) = vals_r__[pos__++];
                }
            }
        }
        size_t lambda_current_i_0_max__ = n_lambda_current;
        for (size_t i_0__ = 0; i_0__ < lambda_current_i_0_max__; ++i_0__) {
            try {
                writer__.cholesky_factor_corr_unconstrain(lambda_current[i_0__]);
            } catch (const std::exception& e) {
                stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable lambda_current: ") + e.what()), current_statement_begin__, prog_reader__());
            }
        }
        current_statement_begin__ = 113;
        if (!(context__.contains_r("lambda_historical")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable lambda_historical missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("lambda_historical");
        pos__ = 0U;
        validate_non_negative_index("lambda_historical", "n_rep", n_rep);
        validate_non_negative_index("lambda_historical", "n_rep", n_rep);
        validate_non_negative_index("lambda_historical", "n_lambda_historical", n_lambda_historical);
        context__.validate_dims("parameter initialization", "lambda_historical", "matrix_d", context__.to_vec(n_lambda_historical,n_rep,n_rep));
        std::vector<Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic> > lambda_historical(n_lambda_historical, Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic>(n_rep, n_rep));
        size_t lambda_historical_j_2_max__ = n_rep;
        size_t lambda_historical_j_1_max__ = n_rep;
        size_t lambda_historical_k_0_max__ = n_lambda_historical;
        for (size_t j_2__ = 0; j_2__ < lambda_historical_j_2_max__; ++j_2__) {
            for (size_t j_1__ = 0; j_1__ < lambda_historical_j_1_max__; ++j_1__) {
                for (size_t k_0__ = 0; k_0__ < lambda_historical_k_0_max__; ++k_0__) {
                    lambda_historical[k_0__](j_1__, j_2__) = vals_r__[pos__++];
                }
            }
        }
        size_t lambda_historical_i_0_max__ = n_lambda_historical;
        for (size_t i_0__ = 0; i_0__ < lambda_historical_i_0_max__; ++i_0__) {
            try {
                writer__.cholesky_factor_corr_unconstrain(lambda_historical[i_0__]);
            } catch (const std::exception& e) {
                stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable lambda_historical: ") + e.what()), current_statement_begin__, prog_reader__());
            }
        }
        current_statement_begin__ = 114;
        if (!(context__.contains_r("rho_current")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable rho_current missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("rho_current");
        pos__ = 0U;
        validate_non_negative_index("rho_current", "n_rho_current", n_rho_current);
        context__.validate_dims("parameter initialization", "rho_current", "vector_d", context__.to_vec(n_rho_current));
        Eigen::Matrix<double, Eigen::Dynamic, 1> rho_current(n_rho_current);
        size_t rho_current_j_1_max__ = n_rho_current;
        for (size_t j_1__ = 0; j_1__ < rho_current_j_1_max__; ++j_1__) {
            rho_current(j_1__) = vals_r__[pos__++];
        }
        try {
            writer__.vector_lub_unconstrain(-(1), 1, rho_current);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable rho_current: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 115;
        if (!(context__.contains_r("rho_historical")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable rho_historical missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("rho_historical");
        pos__ = 0U;
        validate_non_negative_index("rho_historical", "n_rho_historical", n_rho_historical);
        context__.validate_dims("parameter initialization", "rho_historical", "vector_d", context__.to_vec(n_rho_historical));
        Eigen::Matrix<double, Eigen::Dynamic, 1> rho_historical(n_rho_historical);
        size_t rho_historical_j_1_max__ = n_rho_historical;
        for (size_t j_1__ = 0; j_1__ < rho_historical_j_1_max__; ++j_1__) {
            rho_historical(j_1__) = vals_r__[pos__++];
        }
        try {
            writer__.vector_lub_unconstrain(-(1), 1, rho_historical);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable rho_historical: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        params_r__ = writer__.data_r();
        params_i__ = writer__.data_i();
    }
    void transform_inits(const stan::io::var_context& context,
                         Eigen::Matrix<double, Eigen::Dynamic, 1>& params_r,
                         std::ostream* pstream__) const {
      std::vector<double> params_r_vec;
      std::vector<int> params_i_vec;
      transform_inits(context, params_i_vec, params_r_vec, pstream__);
      params_r.resize(params_r_vec.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r(i) = params_r_vec[i];
    }
    template <bool propto__, bool jacobian__, typename T__>
    T__ log_prob(std::vector<T__>& params_r__,
                 std::vector<int>& params_i__,
                 std::ostream* pstream__ = 0) const {
        typedef T__ local_scalar_t__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // dummy to suppress unused var warning
        T__ lp__(0.0);
        stan::math::accumulator<T__> lp_accum__;
        try {
            stan::io::reader<local_scalar_t__> in__(params_r__, params_i__);
            // model parameters
            current_statement_begin__ = 105;
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> y_missing;
            (void) y_missing;  // dummy to suppress unused var warning
            if (jacobian__)
                y_missing = in__.vector_constrain(n_missing, lp__);
            else
                y_missing = in__.vector_constrain(n_missing);
            current_statement_begin__ = 106;
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> alpha_raw;
            (void) alpha_raw;  // dummy to suppress unused var warning
            if (jacobian__)
                alpha_raw = in__.vector_constrain(n_alpha, lp__);
            else
                alpha_raw = in__.vector_constrain(n_alpha);
            current_statement_begin__ = 107;
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> mu;
            (void) mu;  // dummy to suppress unused var warning
            if (jacobian__)
                mu = in__.vector_constrain(n_mu, lp__);
            else
                mu = in__.vector_constrain(n_mu);
            current_statement_begin__ = 108;
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> tau;
            (void) tau;  // dummy to suppress unused var warning
            if (jacobian__)
                tau = in__.vector_lub_constrain(0, s_tau, n_tau, lp__);
            else
                tau = in__.vector_lub_constrain(0, s_tau, n_tau);
            current_statement_begin__ = 109;
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> delta;
            (void) delta;  // dummy to suppress unused var warning
            if (jacobian__)
                delta = in__.vector_constrain(n_delta, lp__);
            else
                delta = in__.vector_constrain(n_delta);
            current_statement_begin__ = 110;
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> beta;
            (void) beta;  // dummy to suppress unused var warning
            if (jacobian__)
                beta = in__.vector_constrain(n_beta, lp__);
            else
                beta = in__.vector_constrain(n_beta);
            current_statement_begin__ = 111;
            std::vector<Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> > sigma;
            size_t sigma_d_0_max__ = n_study;
            sigma.reserve(sigma_d_0_max__);
            for (size_t d_0__ = 0; d_0__ < sigma_d_0_max__; ++d_0__) {
                if (jacobian__)
                    sigma.push_back(in__.vector_lub_constrain(0, s_sigma, n_rep, lp__));
                else
                    sigma.push_back(in__.vector_lub_constrain(0, s_sigma, n_rep));
            }
            current_statement_begin__ = 112;
            std::vector<Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, Eigen::Dynamic> > lambda_current;
            size_t lambda_current_d_0_max__ = n_lambda_current;
            lambda_current.reserve(lambda_current_d_0_max__);
            for (size_t d_0__ = 0; d_0__ < lambda_current_d_0_max__; ++d_0__) {
                if (jacobian__)
                    lambda_current.push_back(in__.cholesky_factor_corr_constrain(n_rep, lp__));
                else
                    lambda_current.push_back(in__.cholesky_factor_corr_constrain(n_rep));
            }
            current_statement_begin__ = 113;
            std::vector<Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, Eigen::Dynamic> > lambda_historical;
            size_t lambda_historical_d_0_max__ = n_lambda_historical;
            lambda_historical.reserve(lambda_historical_d_0_max__);
            for (size_t d_0__ = 0; d_0__ < lambda_historical_d_0_max__; ++d_0__) {
                if (jacobian__)
                    lambda_historical.push_back(in__.cholesky_factor_corr_constrain(n_rep, lp__));
                else
                    lambda_historical.push_back(in__.cholesky_factor_corr_constrain(n_rep));
            }
            current_statement_begin__ = 114;
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> rho_current;
            (void) rho_current;  // dummy to suppress unused var warning
            if (jacobian__)
                rho_current = in__.vector_lub_constrain(-(1), 1, n_rho_current, lp__);
            else
                rho_current = in__.vector_lub_constrain(-(1), 1, n_rho_current);
            current_statement_begin__ = 115;
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> rho_historical;
            (void) rho_historical;  // dummy to suppress unused var warning
            if (jacobian__)
                rho_historical = in__.vector_lub_constrain(-(1), 1, n_rho_historical, lp__);
            else
                rho_historical = in__.vector_lub_constrain(-(1), 1, n_rho_historical);
            // transformed parameters
            current_statement_begin__ = 118;
            validate_non_negative_index("alpha", "n_alpha", n_alpha);
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> alpha(n_alpha);
            stan::math::initialize(alpha, DUMMY_VAR__);
            stan::math::fill(alpha, DUMMY_VAR__);
            current_statement_begin__ = 119;
            validate_non_negative_index("epsilon", "n_rep", n_rep);
            validate_non_negative_index("epsilon", "n_patient", n_patient);
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, Eigen::Dynamic> epsilon(n_rep, n_patient);
            stan::math::initialize(epsilon, DUMMY_VAR__);
            stan::math::fill(epsilon, DUMMY_VAR__);
            current_statement_begin__ = 120;
            validate_non_negative_index("covariance_cholesky", "n_rep", n_rep);
            validate_non_negative_index("covariance_cholesky", "n_rep", n_rep);
            validate_non_negative_index("covariance_cholesky", "n_study", n_study);
            std::vector<Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, Eigen::Dynamic> > covariance_cholesky(n_study, Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, Eigen::Dynamic>(n_rep, n_rep));
            stan::math::initialize(covariance_cholesky, DUMMY_VAR__);
            stan::math::fill(covariance_cholesky, DUMMY_VAR__);
            // transformed parameters block statements
            {
            current_statement_begin__ = 122;
            int index(0);
            (void) index;  // dummy to suppress unused var warning
            stan::math::fill(index, std::numeric_limits<int>::min());
            current_statement_begin__ = 123;
            int last_visit(0);
            (void) last_visit;  // dummy to suppress unused var warning
            stan::math::fill(last_visit, std::numeric_limits<int>::min());
            current_statement_begin__ = 124;
            int first_visit(0);
            (void) first_visit;  // dummy to suppress unused var warning
            stan::math::fill(first_visit, std::numeric_limits<int>::min());
            current_statement_begin__ = 125;
            int col_i(0);
            (void) col_i;  // dummy to suppress unused var warning
            stan::math::fill(col_i, std::numeric_limits<int>::min());
            current_statement_begin__ = 126;
            int row_i(0);
            (void) row_i;  // dummy to suppress unused var warning
            stan::math::fill(row_i, std::numeric_limits<int>::min());
            current_statement_begin__ = 127;
            int col_n(0);
            (void) col_n;  // dummy to suppress unused var warning
            stan::math::fill(col_n, std::numeric_limits<int>::min());
            current_statement_begin__ = 128;
            int row_n(0);
            (void) row_n;  // dummy to suppress unused var warning
            stan::math::fill(row_n, std::numeric_limits<int>::min());
            current_statement_begin__ = 129;
            validate_non_negative_index("alpha_latent", "(n_alpha + 1)", (n_alpha + 1));
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> alpha_latent((n_alpha + 1));
            stan::math::initialize(alpha_latent, DUMMY_VAR__);
            stan::math::fill(alpha_latent, DUMMY_VAR__);
            current_statement_begin__ = 130;
            validate_non_negative_index("delta_latent", "(n_delta + 1)", (n_delta + 1));
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> delta_latent((n_delta + 1));
            stan::math::initialize(delta_latent, DUMMY_VAR__);
            stan::math::fill(delta_latent, DUMMY_VAR__);
            current_statement_begin__ = 131;
            validate_non_negative_index("x_beta_vector", "n_patient", n_patient);
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> x_beta_vector(n_patient);
            stan::math::initialize(x_beta_vector, DUMMY_VAR__);
            stan::math::fill(x_beta_vector, DUMMY_VAR__);
            current_statement_begin__ = 132;
            validate_non_negative_index("means", "n_observe", n_observe);
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> means(n_observe);
            stan::math::initialize(means, DUMMY_VAR__);
            stan::math::fill(means, DUMMY_VAR__);
            current_statement_begin__ = 133;
            validate_non_negative_index("means_matrix", "n_rep", n_rep);
            validate_non_negative_index("means_matrix", "n_patient", n_patient);
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, Eigen::Dynamic> means_matrix(n_rep, n_patient);
            stan::math::initialize(means_matrix, DUMMY_VAR__);
            stan::math::fill(means_matrix, DUMMY_VAR__);
            current_statement_begin__ = 134;
            validate_non_negative_index("y_imputed", "n_observe", n_observe);
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> y_imputed(n_observe);
            stan::math::initialize(y_imputed, DUMMY_VAR__);
            stan::math::fill(y_imputed, DUMMY_VAR__);
            current_statement_begin__ = 135;
            validate_non_negative_index("y_matrix", "n_rep", n_rep);
            validate_non_negative_index("y_matrix", "n_patient", n_patient);
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, Eigen::Dynamic> y_matrix(n_rep, n_patient);
            stan::math::initialize(y_matrix, DUMMY_VAR__);
            stan::math::fill(y_matrix, DUMMY_VAR__);
            current_statement_begin__ = 138;
            if (as_bool(logical_eq(model_type, 3))) {
                current_statement_begin__ = 139;
                stan::math::assign(alpha, add(stan::model::rvalue(mu, stan::model::cons_list(stan::model::index_multi(alpha_rep_index), stan::model::nil_index_list()), "mu"), elt_multiply(stan::model::rvalue(tau, stan::model::cons_list(stan::model::index_multi(alpha_rep_index), stan::model::nil_index_list()), "tau"), alpha_raw)));
            } else {
                current_statement_begin__ = 141;
                stan::math::assign(alpha, alpha_raw);
            }
            current_statement_begin__ = 143;
            stan::model::assign(alpha_latent, 
                        stan::model::cons_list(stan::model::index_uni(1), stan::model::nil_index_list()), 
                        0, 
                        "assigning variable alpha_latent");
            current_statement_begin__ = 144;
            stan::model::assign(alpha_latent, 
                        stan::model::cons_list(stan::model::index_min_max(2, (n_alpha + 1)), stan::model::nil_index_list()), 
                        alpha, 
                        "assigning variable alpha_latent");
            current_statement_begin__ = 145;
            stan::model::assign(delta_latent, 
                        stan::model::cons_list(stan::model::index_uni(1), stan::model::nil_index_list()), 
                        0, 
                        "assigning variable delta_latent");
            current_statement_begin__ = 146;
            stan::model::assign(delta_latent, 
                        stan::model::cons_list(stan::model::index_min_max(2, (n_delta + 1)), stan::model::nil_index_list()), 
                        delta, 
                        "assigning variable delta_latent");
            current_statement_begin__ = 149;
            stan::math::assign(x_beta_vector, rep_vector(0, n_patient));
            current_statement_begin__ = 150;
            if (as_bool(logical_gt(n_beta, 0))) {
                current_statement_begin__ = 151;
                for (int i = 1; i <= n_study_x_beta; ++i) {
                    current_statement_begin__ = 152;
                    stan::math::assign(col_i, get_base1(x_beta_col_index, i, "x_beta_col_index", 1));
                    current_statement_begin__ = 153;
                    stan::math::assign(row_i, get_base1(x_beta_row_index, i, "x_beta_row_index", 1));
                    current_statement_begin__ = 154;
                    stan::math::assign(col_n, get_base1(x_beta_col_n, i, "x_beta_col_n", 1));
                    current_statement_begin__ = 155;
                    stan::math::assign(row_n, get_base1(x_beta_row_n, i, "x_beta_row_n", 1));
                    current_statement_begin__ = 156;
                    stan::model::assign(x_beta_vector, 
                                stan::model::cons_list(stan::model::index_min_max(col_i, ((col_i + col_n) - 1)), stan::model::nil_index_list()), 
                                transpose(multiply(transpose(stan::model::rvalue(beta, stan::model::cons_list(stan::model::index_min_max(row_i, ((row_i + row_n) - 1)), stan::model::nil_index_list()), "beta")), block(x_beta, row_i, col_i, row_n, col_n))), 
                                "assigning variable x_beta_vector");
                }
            }
            current_statement_begin__ = 164;
            if (as_bool(logical_gt(n_beta, 0))) {
                current_statement_begin__ = 165;
                stan::math::assign(means, add(add(stan::model::rvalue(alpha_latent, stan::model::cons_list(stan::model::index_multi(alpha_data_index), stan::model::nil_index_list()), "alpha_latent"), stan::model::rvalue(delta_latent, stan::model::cons_list(stan::model::index_multi(delta_data_index), stan::model::nil_index_list()), "delta_latent")), stan::model::rvalue(x_beta_vector, stan::model::cons_list(stan::model::index_multi(index_patient), stan::model::nil_index_list()), "x_beta_vector")));
            } else {
                current_statement_begin__ = 169;
                stan::math::assign(means, add(stan::model::rvalue(alpha_latent, stan::model::cons_list(stan::model::index_multi(alpha_data_index), stan::model::nil_index_list()), "alpha_latent"), stan::model::rvalue(delta_latent, stan::model::cons_list(stan::model::index_multi(delta_data_index), stan::model::nil_index_list()), "delta_latent")));
            }
            current_statement_begin__ = 173;
            if (as_bool(logical_eq(covariance_current, covariance_unstructured))) {
                current_statement_begin__ = 174;
                stan::model::assign(covariance_cholesky, 
                            stan::model::cons_list(stan::model::index_uni(n_study), stan::model::nil_index_list()), 
                            diag_pre_multiply(get_base1(sigma, n_study, "sigma", 1), get_base1(lambda_current, 1, "lambda_current", 1)), 
                            "assigning variable covariance_cholesky");
            } else if (as_bool(logical_eq(covariance_current, covariance_ar1))) {
                current_statement_begin__ = 179;
                stan::model::assign(covariance_cholesky, 
                            stan::model::cons_list(stan::model::index_uni(n_study), stan::model::nil_index_list()), 
                            diag_pre_multiply(get_base1(sigma, n_study, "sigma", 1), ar1_cholesky(get_base1(rho_current, 1, "rho_current", 1), n_rep, pstream__)), 
                            "assigning variable covariance_cholesky");
            } else {
                current_statement_begin__ = 184;
                stan::model::assign(covariance_cholesky, 
                            stan::model::cons_list(stan::model::index_uni(n_study), stan::model::nil_index_list()), 
                            diag_matrix(get_base1(sigma, n_study, "sigma", 1)), 
                            "assigning variable covariance_cholesky");
            }
            current_statement_begin__ = 188;
            for (int i = 1; i <= (n_study - 1); ++i) {
                current_statement_begin__ = 189;
                if (as_bool(logical_eq(covariance_historical, covariance_unstructured))) {
                    current_statement_begin__ = 190;
                    stan::model::assign(covariance_cholesky, 
                                stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                diag_pre_multiply(get_base1(sigma, i, "sigma", 1), get_base1(lambda_historical, i, "lambda_historical", 1)), 
                                "assigning variable covariance_cholesky");
                } else if (as_bool(logical_eq(covariance_historical, covariance_ar1))) {
                    current_statement_begin__ = 195;
                    stan::model::assign(covariance_cholesky, 
                                stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                diag_pre_multiply(get_base1(sigma, i, "sigma", 1), ar1_cholesky(get_base1(rho_historical, i, "rho_historical", 1), n_rep, pstream__)), 
                                "assigning variable covariance_cholesky");
                } else {
                    current_statement_begin__ = 200;
                    stan::model::assign(covariance_cholesky, 
                                stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                diag_matrix(get_base1(sigma, i, "sigma", 1)), 
                                "assigning variable covariance_cholesky");
                }
            }
            current_statement_begin__ = 205;
            for (int observation = 1; observation <= n_observe; ++observation) {
                current_statement_begin__ = 206;
                stan::model::assign(y_imputed, 
                            stan::model::cons_list(stan::model::index_uni(observation), stan::model::nil_index_list()), 
                            (logical_eq(get_base1(missing, observation, "missing", 1), 1) ? stan::math::promote_scalar<local_scalar_t__>(get_base1(y_missing, get_base1(count_missing, observation, "count_missing", 1), "y_missing", 1)) : stan::math::promote_scalar<local_scalar_t__>(get_base1(y, observation, "y", 1)) ), 
                            "assigning variable y_imputed");
            }
            current_statement_begin__ = 212;
            stan::math::assign(index, 1);
            current_statement_begin__ = 213;
            for (int patient = 1; patient <= n_patient; ++patient) {
                current_statement_begin__ = 214;
                stan::model::assign(y_matrix, 
                            stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(patient), stan::model::nil_index_list())), 
                            segment(y_imputed, index, n_rep), 
                            "assigning variable y_matrix");
                current_statement_begin__ = 215;
                stan::model::assign(means_matrix, 
                            stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(patient), stan::model::nil_index_list())), 
                            segment(means, index, n_rep), 
                            "assigning variable means_matrix");
                current_statement_begin__ = 216;
                stan::math::assign(index, (index + n_rep));
            }
            current_statement_begin__ = 218;
            stan::math::assign(epsilon, subtract(y_matrix, means_matrix));
            }
            // validate transformed parameters
            const char* function__ = "validate transformed params";
            (void) function__;  // dummy to suppress unused var warning
            current_statement_begin__ = 118;
            size_t alpha_j_1_max__ = n_alpha;
            for (size_t j_1__ = 0; j_1__ < alpha_j_1_max__; ++j_1__) {
                if (stan::math::is_uninitialized(alpha(j_1__))) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: alpha" << "(" << j_1__ << ")";
                    stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable alpha: ") + msg__.str()), current_statement_begin__, prog_reader__());
                }
            }
            current_statement_begin__ = 119;
            size_t epsilon_j_1_max__ = n_rep;
            size_t epsilon_j_2_max__ = n_patient;
            for (size_t j_1__ = 0; j_1__ < epsilon_j_1_max__; ++j_1__) {
                for (size_t j_2__ = 0; j_2__ < epsilon_j_2_max__; ++j_2__) {
                    if (stan::math::is_uninitialized(epsilon(j_1__, j_2__))) {
                        std::stringstream msg__;
                        msg__ << "Undefined transformed parameter: epsilon" << "(" << j_1__ << ", " << j_2__ << ")";
                        stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable epsilon: ") + msg__.str()), current_statement_begin__, prog_reader__());
                    }
                }
            }
            current_statement_begin__ = 120;
            size_t covariance_cholesky_k_0_max__ = n_study;
            size_t covariance_cholesky_j_1_max__ = n_rep;
            size_t covariance_cholesky_j_2_max__ = n_rep;
            for (size_t k_0__ = 0; k_0__ < covariance_cholesky_k_0_max__; ++k_0__) {
                for (size_t j_1__ = 0; j_1__ < covariance_cholesky_j_1_max__; ++j_1__) {
                    for (size_t j_2__ = 0; j_2__ < covariance_cholesky_j_2_max__; ++j_2__) {
                        if (stan::math::is_uninitialized(covariance_cholesky[k_0__](j_1__, j_2__))) {
                            std::stringstream msg__;
                            msg__ << "Undefined transformed parameter: covariance_cholesky" << "[" << k_0__ << "]" << "(" << j_1__ << ", " << j_2__ << ")";
                            stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable covariance_cholesky: ") + msg__.str()), current_statement_begin__, prog_reader__());
                        }
                    }
                }
            }
            // model body
            {
            current_statement_begin__ = 223;
            int start(0);
            (void) start;  // dummy to suppress unused var warning
            stan::math::fill(start, std::numeric_limits<int>::min());
            current_statement_begin__ = 224;
            int end(0);
            (void) end;  // dummy to suppress unused var warning
            stan::math::fill(end, std::numeric_limits<int>::min());
            current_statement_begin__ = 225;
            int length(0);
            (void) length;  // dummy to suppress unused var warning
            stan::math::fill(length, std::numeric_limits<int>::min());
            current_statement_begin__ = 226;
            for (int study = 1; study <= n_study; ++study) {
                current_statement_begin__ = 227;
                stan::math::assign(start, get_base1(index_patient_study, study, "index_patient_study", 1));
                current_statement_begin__ = 228;
                stan::math::assign(length, get_base1(n_patient_study, study, "n_patient_study", 1));
                current_statement_begin__ = 229;
                stan::math::assign(end, ((start + length) - 1));
                current_statement_begin__ = 230;
                lp_accum__.add(sum(log_normal_kernel(get_base1(covariance_cholesky, study, "covariance_cholesky", 1), stan::model::rvalue(epsilon, stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_min_max(start, end), stan::model::nil_index_list())), "epsilon"), pstream__)));
            }
            current_statement_begin__ = 239;
            if (as_bool(logical_eq(model_type, 3))) {
                current_statement_begin__ = 240;
                lp_accum__.add(std_normal_log<propto__>(alpha_raw));
                current_statement_begin__ = 241;
                lp_accum__.add(normal_log<propto__>(mu, 0, s_mu));
                current_statement_begin__ = 242;
                lp_accum__.add(uniform_log<propto__>(tau, 0, s_tau));
            } else {
                current_statement_begin__ = 244;
                lp_accum__.add(normal_log<propto__>(alpha_raw, 0, s_alpha));
            }
            current_statement_begin__ = 246;
            lp_accum__.add(normal_log<propto__>(delta, 0, s_delta));
            current_statement_begin__ = 247;
            lp_accum__.add(normal_log<propto__>(beta, 0, s_beta));
            current_statement_begin__ = 248;
            for (int i = 1; i <= n_study; ++i) {
                current_statement_begin__ = 249;
                lp_accum__.add(uniform_log<propto__>(get_base1(sigma, i, "sigma", 1), 0, s_sigma));
            }
            current_statement_begin__ = 251;
            if (as_bool(logical_eq(covariance_current, covariance_unstructured))) {
                current_statement_begin__ = 252;
                lp_accum__.add(lkj_corr_cholesky_log<propto__>(get_base1(lambda_current, 1, "lambda_current", 1), s_lambda));
            } else if (as_bool(logical_eq(covariance_current, covariance_ar1))) {
                current_statement_begin__ = 254;
                lp_accum__.add(uniform_log<propto__>(rho_current, -(1), 1));
            }
            current_statement_begin__ = 256;
            if (as_bool(logical_eq(covariance_historical, covariance_unstructured))) {
                current_statement_begin__ = 257;
                for (int i = 1; i <= n_lambda_historical; ++i) {
                    current_statement_begin__ = 258;
                    lp_accum__.add(lkj_corr_cholesky_log<propto__>(get_base1(lambda_historical, i, "lambda_historical", 1), s_lambda));
                }
            } else if (as_bool(logical_eq(covariance_historical, covariance_ar1))) {
                current_statement_begin__ = 261;
                lp_accum__.add(uniform_log<propto__>(rho_historical, -(1), 1));
            }
            }
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
        lp_accum__.add(lp__);
        return lp_accum__.sum();
    } // log_prob()
    template <bool propto, bool jacobian, typename T_>
    T_ log_prob(Eigen::Matrix<T_,Eigen::Dynamic,1>& params_r,
               std::ostream* pstream = 0) const {
      std::vector<T_> vec_params_r;
      vec_params_r.reserve(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        vec_params_r.push_back(params_r(i));
      std::vector<int> vec_params_i;
      return log_prob<propto,jacobian,T_>(vec_params_r, vec_params_i, pstream);
    }
    void get_param_names(std::vector<std::string>& names__) const {
        names__.resize(0);
        names__.push_back("y_missing");
        names__.push_back("alpha_raw");
        names__.push_back("mu");
        names__.push_back("tau");
        names__.push_back("delta");
        names__.push_back("beta");
        names__.push_back("sigma");
        names__.push_back("lambda_current");
        names__.push_back("lambda_historical");
        names__.push_back("rho_current");
        names__.push_back("rho_historical");
        names__.push_back("alpha");
        names__.push_back("epsilon");
        names__.push_back("covariance_cholesky");
    }
    void get_dims(std::vector<std::vector<size_t> >& dimss__) const {
        dimss__.resize(0);
        std::vector<size_t> dims__;
        dims__.resize(0);
        dims__.push_back(n_missing);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(n_alpha);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(n_mu);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(n_tau);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(n_delta);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(n_beta);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(n_study);
        dims__.push_back(n_rep);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(n_lambda_current);
        dims__.push_back(n_rep);
        dims__.push_back(n_rep);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(n_lambda_historical);
        dims__.push_back(n_rep);
        dims__.push_back(n_rep);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(n_rho_current);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(n_rho_historical);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(n_alpha);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(n_rep);
        dims__.push_back(n_patient);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(n_study);
        dims__.push_back(n_rep);
        dims__.push_back(n_rep);
        dimss__.push_back(dims__);
    }
    template <typename RNG>
    void write_array(RNG& base_rng__,
                     std::vector<double>& params_r__,
                     std::vector<int>& params_i__,
                     std::vector<double>& vars__,
                     bool include_tparams__ = true,
                     bool include_gqs__ = true,
                     std::ostream* pstream__ = 0) const {
        typedef double local_scalar_t__;
        vars__.resize(0);
        stan::io::reader<local_scalar_t__> in__(params_r__, params_i__);
        static const char* function__ = "model_historicalborrowlong_namespace::write_array";
        (void) function__;  // dummy to suppress unused var warning
        // read-transform, write parameters
        Eigen::Matrix<double, Eigen::Dynamic, 1> y_missing = in__.vector_constrain(n_missing);
        size_t y_missing_j_1_max__ = n_missing;
        for (size_t j_1__ = 0; j_1__ < y_missing_j_1_max__; ++j_1__) {
            vars__.push_back(y_missing(j_1__));
        }
        Eigen::Matrix<double, Eigen::Dynamic, 1> alpha_raw = in__.vector_constrain(n_alpha);
        size_t alpha_raw_j_1_max__ = n_alpha;
        for (size_t j_1__ = 0; j_1__ < alpha_raw_j_1_max__; ++j_1__) {
            vars__.push_back(alpha_raw(j_1__));
        }
        Eigen::Matrix<double, Eigen::Dynamic, 1> mu = in__.vector_constrain(n_mu);
        size_t mu_j_1_max__ = n_mu;
        for (size_t j_1__ = 0; j_1__ < mu_j_1_max__; ++j_1__) {
            vars__.push_back(mu(j_1__));
        }
        Eigen::Matrix<double, Eigen::Dynamic, 1> tau = in__.vector_lub_constrain(0, s_tau, n_tau);
        size_t tau_j_1_max__ = n_tau;
        for (size_t j_1__ = 0; j_1__ < tau_j_1_max__; ++j_1__) {
            vars__.push_back(tau(j_1__));
        }
        Eigen::Matrix<double, Eigen::Dynamic, 1> delta = in__.vector_constrain(n_delta);
        size_t delta_j_1_max__ = n_delta;
        for (size_t j_1__ = 0; j_1__ < delta_j_1_max__; ++j_1__) {
            vars__.push_back(delta(j_1__));
        }
        Eigen::Matrix<double, Eigen::Dynamic, 1> beta = in__.vector_constrain(n_beta);
        size_t beta_j_1_max__ = n_beta;
        for (size_t j_1__ = 0; j_1__ < beta_j_1_max__; ++j_1__) {
            vars__.push_back(beta(j_1__));
        }
        std::vector<Eigen::Matrix<double, Eigen::Dynamic, 1> > sigma;
        size_t sigma_d_0_max__ = n_study;
        sigma.reserve(sigma_d_0_max__);
        for (size_t d_0__ = 0; d_0__ < sigma_d_0_max__; ++d_0__) {
            sigma.push_back(in__.vector_lub_constrain(0, s_sigma, n_rep));
        }
        size_t sigma_j_1_max__ = n_rep;
        size_t sigma_k_0_max__ = n_study;
        for (size_t j_1__ = 0; j_1__ < sigma_j_1_max__; ++j_1__) {
            for (size_t k_0__ = 0; k_0__ < sigma_k_0_max__; ++k_0__) {
                vars__.push_back(sigma[k_0__](j_1__));
            }
        }
        std::vector<Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic> > lambda_current;
        size_t lambda_current_d_0_max__ = n_lambda_current;
        lambda_current.reserve(lambda_current_d_0_max__);
        for (size_t d_0__ = 0; d_0__ < lambda_current_d_0_max__; ++d_0__) {
            lambda_current.push_back(in__.cholesky_factor_corr_constrain(n_rep));
        }
        size_t lambda_current_j_2_max__ = n_rep;
        size_t lambda_current_j_1_max__ = n_rep;
        size_t lambda_current_k_0_max__ = n_lambda_current;
        for (size_t j_2__ = 0; j_2__ < lambda_current_j_2_max__; ++j_2__) {
            for (size_t j_1__ = 0; j_1__ < lambda_current_j_1_max__; ++j_1__) {
                for (size_t k_0__ = 0; k_0__ < lambda_current_k_0_max__; ++k_0__) {
                    vars__.push_back(lambda_current[k_0__](j_1__, j_2__));
                }
            }
        }
        std::vector<Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic> > lambda_historical;
        size_t lambda_historical_d_0_max__ = n_lambda_historical;
        lambda_historical.reserve(lambda_historical_d_0_max__);
        for (size_t d_0__ = 0; d_0__ < lambda_historical_d_0_max__; ++d_0__) {
            lambda_historical.push_back(in__.cholesky_factor_corr_constrain(n_rep));
        }
        size_t lambda_historical_j_2_max__ = n_rep;
        size_t lambda_historical_j_1_max__ = n_rep;
        size_t lambda_historical_k_0_max__ = n_lambda_historical;
        for (size_t j_2__ = 0; j_2__ < lambda_historical_j_2_max__; ++j_2__) {
            for (size_t j_1__ = 0; j_1__ < lambda_historical_j_1_max__; ++j_1__) {
                for (size_t k_0__ = 0; k_0__ < lambda_historical_k_0_max__; ++k_0__) {
                    vars__.push_back(lambda_historical[k_0__](j_1__, j_2__));
                }
            }
        }
        Eigen::Matrix<double, Eigen::Dynamic, 1> rho_current = in__.vector_lub_constrain(-(1), 1, n_rho_current);
        size_t rho_current_j_1_max__ = n_rho_current;
        for (size_t j_1__ = 0; j_1__ < rho_current_j_1_max__; ++j_1__) {
            vars__.push_back(rho_current(j_1__));
        }
        Eigen::Matrix<double, Eigen::Dynamic, 1> rho_historical = in__.vector_lub_constrain(-(1), 1, n_rho_historical);
        size_t rho_historical_j_1_max__ = n_rho_historical;
        for (size_t j_1__ = 0; j_1__ < rho_historical_j_1_max__; ++j_1__) {
            vars__.push_back(rho_historical(j_1__));
        }
        double lp__ = 0.0;
        (void) lp__;  // dummy to suppress unused var warning
        stan::math::accumulator<double> lp_accum__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
        if (!include_tparams__ && !include_gqs__) return;
        try {
            // declare and define transformed parameters
            current_statement_begin__ = 118;
            validate_non_negative_index("alpha", "n_alpha", n_alpha);
            Eigen::Matrix<double, Eigen::Dynamic, 1> alpha(n_alpha);
            stan::math::initialize(alpha, DUMMY_VAR__);
            stan::math::fill(alpha, DUMMY_VAR__);
            current_statement_begin__ = 119;
            validate_non_negative_index("epsilon", "n_rep", n_rep);
            validate_non_negative_index("epsilon", "n_patient", n_patient);
            Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic> epsilon(n_rep, n_patient);
            stan::math::initialize(epsilon, DUMMY_VAR__);
            stan::math::fill(epsilon, DUMMY_VAR__);
            current_statement_begin__ = 120;
            validate_non_negative_index("covariance_cholesky", "n_rep", n_rep);
            validate_non_negative_index("covariance_cholesky", "n_rep", n_rep);
            validate_non_negative_index("covariance_cholesky", "n_study", n_study);
            std::vector<Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic> > covariance_cholesky(n_study, Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic>(n_rep, n_rep));
            stan::math::initialize(covariance_cholesky, DUMMY_VAR__);
            stan::math::fill(covariance_cholesky, DUMMY_VAR__);
            // do transformed parameters statements
            {
            current_statement_begin__ = 122;
            int index(0);
            (void) index;  // dummy to suppress unused var warning
            stan::math::fill(index, std::numeric_limits<int>::min());
            current_statement_begin__ = 123;
            int last_visit(0);
            (void) last_visit;  // dummy to suppress unused var warning
            stan::math::fill(last_visit, std::numeric_limits<int>::min());
            current_statement_begin__ = 124;
            int first_visit(0);
            (void) first_visit;  // dummy to suppress unused var warning
            stan::math::fill(first_visit, std::numeric_limits<int>::min());
            current_statement_begin__ = 125;
            int col_i(0);
            (void) col_i;  // dummy to suppress unused var warning
            stan::math::fill(col_i, std::numeric_limits<int>::min());
            current_statement_begin__ = 126;
            int row_i(0);
            (void) row_i;  // dummy to suppress unused var warning
            stan::math::fill(row_i, std::numeric_limits<int>::min());
            current_statement_begin__ = 127;
            int col_n(0);
            (void) col_n;  // dummy to suppress unused var warning
            stan::math::fill(col_n, std::numeric_limits<int>::min());
            current_statement_begin__ = 128;
            int row_n(0);
            (void) row_n;  // dummy to suppress unused var warning
            stan::math::fill(row_n, std::numeric_limits<int>::min());
            current_statement_begin__ = 129;
            validate_non_negative_index("alpha_latent", "(n_alpha + 1)", (n_alpha + 1));
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> alpha_latent((n_alpha + 1));
            stan::math::initialize(alpha_latent, DUMMY_VAR__);
            stan::math::fill(alpha_latent, DUMMY_VAR__);
            current_statement_begin__ = 130;
            validate_non_negative_index("delta_latent", "(n_delta + 1)", (n_delta + 1));
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> delta_latent((n_delta + 1));
            stan::math::initialize(delta_latent, DUMMY_VAR__);
            stan::math::fill(delta_latent, DUMMY_VAR__);
            current_statement_begin__ = 131;
            validate_non_negative_index("x_beta_vector", "n_patient", n_patient);
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> x_beta_vector(n_patient);
            stan::math::initialize(x_beta_vector, DUMMY_VAR__);
            stan::math::fill(x_beta_vector, DUMMY_VAR__);
            current_statement_begin__ = 132;
            validate_non_negative_index("means", "n_observe", n_observe);
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> means(n_observe);
            stan::math::initialize(means, DUMMY_VAR__);
            stan::math::fill(means, DUMMY_VAR__);
            current_statement_begin__ = 133;
            validate_non_negative_index("means_matrix", "n_rep", n_rep);
            validate_non_negative_index("means_matrix", "n_patient", n_patient);
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, Eigen::Dynamic> means_matrix(n_rep, n_patient);
            stan::math::initialize(means_matrix, DUMMY_VAR__);
            stan::math::fill(means_matrix, DUMMY_VAR__);
            current_statement_begin__ = 134;
            validate_non_negative_index("y_imputed", "n_observe", n_observe);
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> y_imputed(n_observe);
            stan::math::initialize(y_imputed, DUMMY_VAR__);
            stan::math::fill(y_imputed, DUMMY_VAR__);
            current_statement_begin__ = 135;
            validate_non_negative_index("y_matrix", "n_rep", n_rep);
            validate_non_negative_index("y_matrix", "n_patient", n_patient);
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, Eigen::Dynamic> y_matrix(n_rep, n_patient);
            stan::math::initialize(y_matrix, DUMMY_VAR__);
            stan::math::fill(y_matrix, DUMMY_VAR__);
            current_statement_begin__ = 138;
            if (as_bool(logical_eq(model_type, 3))) {
                current_statement_begin__ = 139;
                stan::math::assign(alpha, add(stan::model::rvalue(mu, stan::model::cons_list(stan::model::index_multi(alpha_rep_index), stan::model::nil_index_list()), "mu"), elt_multiply(stan::model::rvalue(tau, stan::model::cons_list(stan::model::index_multi(alpha_rep_index), stan::model::nil_index_list()), "tau"), alpha_raw)));
            } else {
                current_statement_begin__ = 141;
                stan::math::assign(alpha, alpha_raw);
            }
            current_statement_begin__ = 143;
            stan::model::assign(alpha_latent, 
                        stan::model::cons_list(stan::model::index_uni(1), stan::model::nil_index_list()), 
                        0, 
                        "assigning variable alpha_latent");
            current_statement_begin__ = 144;
            stan::model::assign(alpha_latent, 
                        stan::model::cons_list(stan::model::index_min_max(2, (n_alpha + 1)), stan::model::nil_index_list()), 
                        alpha, 
                        "assigning variable alpha_latent");
            current_statement_begin__ = 145;
            stan::model::assign(delta_latent, 
                        stan::model::cons_list(stan::model::index_uni(1), stan::model::nil_index_list()), 
                        0, 
                        "assigning variable delta_latent");
            current_statement_begin__ = 146;
            stan::model::assign(delta_latent, 
                        stan::model::cons_list(stan::model::index_min_max(2, (n_delta + 1)), stan::model::nil_index_list()), 
                        delta, 
                        "assigning variable delta_latent");
            current_statement_begin__ = 149;
            stan::math::assign(x_beta_vector, rep_vector(0, n_patient));
            current_statement_begin__ = 150;
            if (as_bool(logical_gt(n_beta, 0))) {
                current_statement_begin__ = 151;
                for (int i = 1; i <= n_study_x_beta; ++i) {
                    current_statement_begin__ = 152;
                    stan::math::assign(col_i, get_base1(x_beta_col_index, i, "x_beta_col_index", 1));
                    current_statement_begin__ = 153;
                    stan::math::assign(row_i, get_base1(x_beta_row_index, i, "x_beta_row_index", 1));
                    current_statement_begin__ = 154;
                    stan::math::assign(col_n, get_base1(x_beta_col_n, i, "x_beta_col_n", 1));
                    current_statement_begin__ = 155;
                    stan::math::assign(row_n, get_base1(x_beta_row_n, i, "x_beta_row_n", 1));
                    current_statement_begin__ = 156;
                    stan::model::assign(x_beta_vector, 
                                stan::model::cons_list(stan::model::index_min_max(col_i, ((col_i + col_n) - 1)), stan::model::nil_index_list()), 
                                transpose(multiply(transpose(stan::model::rvalue(beta, stan::model::cons_list(stan::model::index_min_max(row_i, ((row_i + row_n) - 1)), stan::model::nil_index_list()), "beta")), block(x_beta, row_i, col_i, row_n, col_n))), 
                                "assigning variable x_beta_vector");
                }
            }
            current_statement_begin__ = 164;
            if (as_bool(logical_gt(n_beta, 0))) {
                current_statement_begin__ = 165;
                stan::math::assign(means, add(add(stan::model::rvalue(alpha_latent, stan::model::cons_list(stan::model::index_multi(alpha_data_index), stan::model::nil_index_list()), "alpha_latent"), stan::model::rvalue(delta_latent, stan::model::cons_list(stan::model::index_multi(delta_data_index), stan::model::nil_index_list()), "delta_latent")), stan::model::rvalue(x_beta_vector, stan::model::cons_list(stan::model::index_multi(index_patient), stan::model::nil_index_list()), "x_beta_vector")));
            } else {
                current_statement_begin__ = 169;
                stan::math::assign(means, add(stan::model::rvalue(alpha_latent, stan::model::cons_list(stan::model::index_multi(alpha_data_index), stan::model::nil_index_list()), "alpha_latent"), stan::model::rvalue(delta_latent, stan::model::cons_list(stan::model::index_multi(delta_data_index), stan::model::nil_index_list()), "delta_latent")));
            }
            current_statement_begin__ = 173;
            if (as_bool(logical_eq(covariance_current, covariance_unstructured))) {
                current_statement_begin__ = 174;
                stan::model::assign(covariance_cholesky, 
                            stan::model::cons_list(stan::model::index_uni(n_study), stan::model::nil_index_list()), 
                            diag_pre_multiply(get_base1(sigma, n_study, "sigma", 1), get_base1(lambda_current, 1, "lambda_current", 1)), 
                            "assigning variable covariance_cholesky");
            } else if (as_bool(logical_eq(covariance_current, covariance_ar1))) {
                current_statement_begin__ = 179;
                stan::model::assign(covariance_cholesky, 
                            stan::model::cons_list(stan::model::index_uni(n_study), stan::model::nil_index_list()), 
                            diag_pre_multiply(get_base1(sigma, n_study, "sigma", 1), ar1_cholesky(get_base1(rho_current, 1, "rho_current", 1), n_rep, pstream__)), 
                            "assigning variable covariance_cholesky");
            } else {
                current_statement_begin__ = 184;
                stan::model::assign(covariance_cholesky, 
                            stan::model::cons_list(stan::model::index_uni(n_study), stan::model::nil_index_list()), 
                            diag_matrix(get_base1(sigma, n_study, "sigma", 1)), 
                            "assigning variable covariance_cholesky");
            }
            current_statement_begin__ = 188;
            for (int i = 1; i <= (n_study - 1); ++i) {
                current_statement_begin__ = 189;
                if (as_bool(logical_eq(covariance_historical, covariance_unstructured))) {
                    current_statement_begin__ = 190;
                    stan::model::assign(covariance_cholesky, 
                                stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                diag_pre_multiply(get_base1(sigma, i, "sigma", 1), get_base1(lambda_historical, i, "lambda_historical", 1)), 
                                "assigning variable covariance_cholesky");
                } else if (as_bool(logical_eq(covariance_historical, covariance_ar1))) {
                    current_statement_begin__ = 195;
                    stan::model::assign(covariance_cholesky, 
                                stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                diag_pre_multiply(get_base1(sigma, i, "sigma", 1), ar1_cholesky(get_base1(rho_historical, i, "rho_historical", 1), n_rep, pstream__)), 
                                "assigning variable covariance_cholesky");
                } else {
                    current_statement_begin__ = 200;
                    stan::model::assign(covariance_cholesky, 
                                stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                diag_matrix(get_base1(sigma, i, "sigma", 1)), 
                                "assigning variable covariance_cholesky");
                }
            }
            current_statement_begin__ = 205;
            for (int observation = 1; observation <= n_observe; ++observation) {
                current_statement_begin__ = 206;
                stan::model::assign(y_imputed, 
                            stan::model::cons_list(stan::model::index_uni(observation), stan::model::nil_index_list()), 
                            (logical_eq(get_base1(missing, observation, "missing", 1), 1) ? stan::math::promote_scalar<local_scalar_t__>(get_base1(y_missing, get_base1(count_missing, observation, "count_missing", 1), "y_missing", 1)) : stan::math::promote_scalar<local_scalar_t__>(get_base1(y, observation, "y", 1)) ), 
                            "assigning variable y_imputed");
            }
            current_statement_begin__ = 212;
            stan::math::assign(index, 1);
            current_statement_begin__ = 213;
            for (int patient = 1; patient <= n_patient; ++patient) {
                current_statement_begin__ = 214;
                stan::model::assign(y_matrix, 
                            stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(patient), stan::model::nil_index_list())), 
                            segment(y_imputed, index, n_rep), 
                            "assigning variable y_matrix");
                current_statement_begin__ = 215;
                stan::model::assign(means_matrix, 
                            stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(patient), stan::model::nil_index_list())), 
                            segment(means, index, n_rep), 
                            "assigning variable means_matrix");
                current_statement_begin__ = 216;
                stan::math::assign(index, (index + n_rep));
            }
            current_statement_begin__ = 218;
            stan::math::assign(epsilon, subtract(y_matrix, means_matrix));
            }
            if (!include_gqs__ && !include_tparams__) return;
            // validate transformed parameters
            const char* function__ = "validate transformed params";
            (void) function__;  // dummy to suppress unused var warning
            // write transformed parameters
            if (include_tparams__) {
                size_t alpha_j_1_max__ = n_alpha;
                for (size_t j_1__ = 0; j_1__ < alpha_j_1_max__; ++j_1__) {
                    vars__.push_back(alpha(j_1__));
                }
                size_t epsilon_j_2_max__ = n_patient;
                size_t epsilon_j_1_max__ = n_rep;
                for (size_t j_2__ = 0; j_2__ < epsilon_j_2_max__; ++j_2__) {
                    for (size_t j_1__ = 0; j_1__ < epsilon_j_1_max__; ++j_1__) {
                        vars__.push_back(epsilon(j_1__, j_2__));
                    }
                }
                size_t covariance_cholesky_j_2_max__ = n_rep;
                size_t covariance_cholesky_j_1_max__ = n_rep;
                size_t covariance_cholesky_k_0_max__ = n_study;
                for (size_t j_2__ = 0; j_2__ < covariance_cholesky_j_2_max__; ++j_2__) {
                    for (size_t j_1__ = 0; j_1__ < covariance_cholesky_j_1_max__; ++j_1__) {
                        for (size_t k_0__ = 0; k_0__ < covariance_cholesky_k_0_max__; ++k_0__) {
                            vars__.push_back(covariance_cholesky[k_0__](j_1__, j_2__));
                        }
                    }
                }
            }
            if (!include_gqs__) return;
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
    }
    template <typename RNG>
    void write_array(RNG& base_rng,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& vars,
                     bool include_tparams = true,
                     bool include_gqs = true,
                     std::ostream* pstream = 0) const {
      std::vector<double> params_r_vec(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r_vec[i] = params_r(i);
      std::vector<double> vars_vec;
      std::vector<int> params_i_vec;
      write_array(base_rng, params_r_vec, params_i_vec, vars_vec, include_tparams, include_gqs, pstream);
      vars.resize(vars_vec.size());
      for (int i = 0; i < vars.size(); ++i)
        vars(i) = vars_vec[i];
    }
    std::string model_name() const {
        return "model_historicalborrowlong";
    }
    void constrained_param_names(std::vector<std::string>& param_names__,
                                 bool include_tparams__ = true,
                                 bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        size_t y_missing_j_1_max__ = n_missing;
        for (size_t j_1__ = 0; j_1__ < y_missing_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "y_missing" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t alpha_raw_j_1_max__ = n_alpha;
        for (size_t j_1__ = 0; j_1__ < alpha_raw_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "alpha_raw" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t mu_j_1_max__ = n_mu;
        for (size_t j_1__ = 0; j_1__ < mu_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "mu" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t tau_j_1_max__ = n_tau;
        for (size_t j_1__ = 0; j_1__ < tau_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "tau" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t delta_j_1_max__ = n_delta;
        for (size_t j_1__ = 0; j_1__ < delta_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "delta" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t beta_j_1_max__ = n_beta;
        for (size_t j_1__ = 0; j_1__ < beta_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "beta" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t sigma_j_1_max__ = n_rep;
        size_t sigma_k_0_max__ = n_study;
        for (size_t j_1__ = 0; j_1__ < sigma_j_1_max__; ++j_1__) {
            for (size_t k_0__ = 0; k_0__ < sigma_k_0_max__; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "sigma" << '.' << k_0__ + 1 << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        size_t lambda_current_j_2_max__ = n_rep;
        size_t lambda_current_j_1_max__ = n_rep;
        size_t lambda_current_k_0_max__ = n_lambda_current;
        for (size_t j_2__ = 0; j_2__ < lambda_current_j_2_max__; ++j_2__) {
            for (size_t j_1__ = 0; j_1__ < lambda_current_j_1_max__; ++j_1__) {
                for (size_t k_0__ = 0; k_0__ < lambda_current_k_0_max__; ++k_0__) {
                    param_name_stream__.str(std::string());
                    param_name_stream__ << "lambda_current" << '.' << k_0__ + 1 << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                    param_names__.push_back(param_name_stream__.str());
                }
            }
        }
        size_t lambda_historical_j_2_max__ = n_rep;
        size_t lambda_historical_j_1_max__ = n_rep;
        size_t lambda_historical_k_0_max__ = n_lambda_historical;
        for (size_t j_2__ = 0; j_2__ < lambda_historical_j_2_max__; ++j_2__) {
            for (size_t j_1__ = 0; j_1__ < lambda_historical_j_1_max__; ++j_1__) {
                for (size_t k_0__ = 0; k_0__ < lambda_historical_k_0_max__; ++k_0__) {
                    param_name_stream__.str(std::string());
                    param_name_stream__ << "lambda_historical" << '.' << k_0__ + 1 << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                    param_names__.push_back(param_name_stream__.str());
                }
            }
        }
        size_t rho_current_j_1_max__ = n_rho_current;
        for (size_t j_1__ = 0; j_1__ < rho_current_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "rho_current" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t rho_historical_j_1_max__ = n_rho_historical;
        for (size_t j_1__ = 0; j_1__ < rho_historical_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "rho_historical" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        if (!include_gqs__ && !include_tparams__) return;
        if (include_tparams__) {
            size_t alpha_j_1_max__ = n_alpha;
            for (size_t j_1__ = 0; j_1__ < alpha_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "alpha" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t epsilon_j_2_max__ = n_patient;
            size_t epsilon_j_1_max__ = n_rep;
            for (size_t j_2__ = 0; j_2__ < epsilon_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < epsilon_j_1_max__; ++j_1__) {
                    param_name_stream__.str(std::string());
                    param_name_stream__ << "epsilon" << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                    param_names__.push_back(param_name_stream__.str());
                }
            }
            size_t covariance_cholesky_j_2_max__ = n_rep;
            size_t covariance_cholesky_j_1_max__ = n_rep;
            size_t covariance_cholesky_k_0_max__ = n_study;
            for (size_t j_2__ = 0; j_2__ < covariance_cholesky_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < covariance_cholesky_j_1_max__; ++j_1__) {
                    for (size_t k_0__ = 0; k_0__ < covariance_cholesky_k_0_max__; ++k_0__) {
                        param_name_stream__.str(std::string());
                        param_name_stream__ << "covariance_cholesky" << '.' << k_0__ + 1 << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                        param_names__.push_back(param_name_stream__.str());
                    }
                }
            }
        }
        if (!include_gqs__) return;
    }
    void unconstrained_param_names(std::vector<std::string>& param_names__,
                                   bool include_tparams__ = true,
                                   bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        size_t y_missing_j_1_max__ = n_missing;
        for (size_t j_1__ = 0; j_1__ < y_missing_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "y_missing" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t alpha_raw_j_1_max__ = n_alpha;
        for (size_t j_1__ = 0; j_1__ < alpha_raw_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "alpha_raw" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t mu_j_1_max__ = n_mu;
        for (size_t j_1__ = 0; j_1__ < mu_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "mu" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t tau_j_1_max__ = n_tau;
        for (size_t j_1__ = 0; j_1__ < tau_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "tau" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t delta_j_1_max__ = n_delta;
        for (size_t j_1__ = 0; j_1__ < delta_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "delta" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t beta_j_1_max__ = n_beta;
        for (size_t j_1__ = 0; j_1__ < beta_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "beta" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t sigma_j_1_max__ = n_rep;
        size_t sigma_k_0_max__ = n_study;
        for (size_t j_1__ = 0; j_1__ < sigma_j_1_max__; ++j_1__) {
            for (size_t k_0__ = 0; k_0__ < sigma_k_0_max__; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "sigma" << '.' << k_0__ + 1 << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        size_t lambda_current_j_1_max__ = ((n_rep * (n_rep - 1)) / 2);
        size_t lambda_current_k_0_max__ = n_lambda_current;
        for (size_t j_1__ = 0; j_1__ < lambda_current_j_1_max__; ++j_1__) {
            for (size_t k_0__ = 0; k_0__ < lambda_current_k_0_max__; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "lambda_current" << '.' << k_0__ + 1 << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        size_t lambda_historical_j_1_max__ = ((n_rep * (n_rep - 1)) / 2);
        size_t lambda_historical_k_0_max__ = n_lambda_historical;
        for (size_t j_1__ = 0; j_1__ < lambda_historical_j_1_max__; ++j_1__) {
            for (size_t k_0__ = 0; k_0__ < lambda_historical_k_0_max__; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "lambda_historical" << '.' << k_0__ + 1 << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        size_t rho_current_j_1_max__ = n_rho_current;
        for (size_t j_1__ = 0; j_1__ < rho_current_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "rho_current" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t rho_historical_j_1_max__ = n_rho_historical;
        for (size_t j_1__ = 0; j_1__ < rho_historical_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "rho_historical" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        if (!include_gqs__ && !include_tparams__) return;
        if (include_tparams__) {
            size_t alpha_j_1_max__ = n_alpha;
            for (size_t j_1__ = 0; j_1__ < alpha_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "alpha" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t epsilon_j_2_max__ = n_patient;
            size_t epsilon_j_1_max__ = n_rep;
            for (size_t j_2__ = 0; j_2__ < epsilon_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < epsilon_j_1_max__; ++j_1__) {
                    param_name_stream__.str(std::string());
                    param_name_stream__ << "epsilon" << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                    param_names__.push_back(param_name_stream__.str());
                }
            }
            size_t covariance_cholesky_j_2_max__ = n_rep;
            size_t covariance_cholesky_j_1_max__ = n_rep;
            size_t covariance_cholesky_k_0_max__ = n_study;
            for (size_t j_2__ = 0; j_2__ < covariance_cholesky_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < covariance_cholesky_j_1_max__; ++j_1__) {
                    for (size_t k_0__ = 0; k_0__ < covariance_cholesky_k_0_max__; ++k_0__) {
                        param_name_stream__.str(std::string());
                        param_name_stream__ << "covariance_cholesky" << '.' << k_0__ + 1 << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                        param_names__.push_back(param_name_stream__.str());
                    }
                }
            }
        }
        if (!include_gqs__) return;
    }
}; // model
}  // namespace
typedef model_historicalborrowlong_namespace::model_historicalborrowlong stan_model;
#ifndef USING_R
stan::model::model_base& new_model(
        stan::io::var_context& data_context,
        unsigned int seed,
        std::ostream* msg_stream) {
  stan_model* m = new stan_model(data_context, seed, msg_stream);
  return *m;
}
#endif
#endif
