% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hbl_metrics.R
\name{hbl_metrics}
\alias{hbl_metrics}
\title{Borrowing metrics}
\usage{
hbl_metrics(borrow, pool, independent)
}
\arguments{
\item{borrow}{A data frame returned by \code{\link[=hbl_summary]{hbl_summary()}}
for the hierarchical model.}

\item{pool}{A data frame returned by \code{\link[=hbl_summary]{hbl_summary()}}
for the pooled model.}

\item{independent}{A data frame returned by \code{\link[=hbl_summary]{hbl_summary()}}
for the independent model.}
}
\value{
A data frame with borrowing metrics.
}
\description{
Calculate historical borrowing metrics using
summary output from a fitted borrowing model and
analogous summaries from the benchmark models.
}
\examples{
if (!identical(Sys.getenv("HBL_TEST", unset = ""), "")) {
set.seed(0)
data <- hbl_sim_independent(
  n_study = 2,
  n_group = 2,
  n_patient = 5,
  n_rep = 3
)$data
tmp <- utils::capture.output(
  suppressWarnings(
    mcmc_borrow <- hbl_mcmc_hierarchical(
      data,
      chains = 1,
      warmup = 10,
      iter = 20,
      seed = 0
    )
  )
)
tmp <- utils::capture.output(
  suppressWarnings(
    mcmc_pool <- hbl_mcmc_pool(
      data,
      chains = 1,
      warmup = 10,
      iter = 20,
      seed = 0
    )
  )
)
tmp <- utils::capture.output(
  suppressWarnings(
    mcmc_independent <- hbl_mcmc_independent(
      data,
      chains = 1,
      warmup = 10,
      iter = 20,
      seed = 0
    )
  )
)
borrow <- hbl_summary(mcmc_borrow, data)
pool <- hbl_summary(mcmc_pool, data)
independent <- hbl_summary(mcmc_independent, data)
hbl_metrics(
  borrow = borrow,
  pool = pool,
  independent = independent
)
}
}
\seealso{
Other summary: 
\code{\link{hbl_summary}()}
}
\concept{summary}
