% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hb_data.R
\name{hb_data}
\alias{hb_data}
\title{Standardize data}
\usage{
hb_data(
  data,
  response,
  study,
  study_reference,
  group,
  group_reference,
  patient,
  covariates
)
}
\arguments{
\item{data}{A tidy data frame or \code{tibble} with the data.}

\item{response}{Character of length 1,
name of the column in \code{data} with the response/outcome variable.
\code{data[[response]]} must be a continuous variable,
and it \emph{should} be the change from baseline of a
clinical endpoint of interest, as opposed to just
the raw response. Treatment differences
are computed directly from this scale, please supply
change from baseline unless you are absolutely certain
that treatment differences computed directly from
this quantity are clinically meaningful.}

\item{study}{Character of length 1,
name of the column in \code{data} with the study ID.}

\item{study_reference}{Atomic of length 1,
element of the \code{study} column that indicates
the current study.
(The other studies are historical studies.)}

\item{group}{Character of length 1,
name of the column in \code{data} with the group ID.}

\item{group_reference}{Atomic of length 1,
element of the \code{group} column that indicates
the control group.
(The other groups may be treatment groups.)}

\item{patient}{Character of length 1,
name of the column in \code{data} with the patient ID.}

\item{covariates}{Character vector of column names
in \code{data} with the columns with baseline covariates.
These can be continuous, categorical, or binary.
Regardless, \code{historicalborrow} derives the appropriate
model matrix.}
}
\value{
A standardized tidy data frame with one row per patient
and the following columns:
\itemize{
\item \code{response}: continuous response/outcome variable. (Should be
change from baseline of an outcome of interest.)
\item \code{study_label}: human-readable label of the study.
\item \code{study}: integer study index with the max index equal to the
current study (at \code{study_reference}).
\item \code{group_label}: human-readable group label (e.g. treatment arm name).
\item \code{group}: integer group index with an index of 1 equal to the control
group (at \code{group_reference}).
\item \code{patient_label}: original patient ID.
\item \code{patient}: integer patient index.
\item \verb{covariate_*}: baseline covariate columns.
}
}
\description{
Standardize a tidy input dataset.
}
\details{
Users do not normally need to call this function.
It mainly serves exposes the indexing behavior of
studies and group levels to aid in interpreting
summary tables.
}
\examples{
data <- hb_sim_independent(n_continuous = 1, n_study = 2)$data
data <- dplyr::select(
  data,
  study,
  group,
  patient,
  response,
  tidyselect::everything()
)
colnames(data) <- c("trial", "arm", "subject", "change", "cov1", "cov2")
data$trial <- paste0("trial", data$trial)
data$arm <- paste0("arm", data$arm)
hb_data(
  data = data,
  response = "change",
  study = "trial",
  study_reference = "trial1",
  group = "arm",
  group_reference = "arm1",
  patient = "subject",
  covariates = c("cov1", "cov2")
)
}
\seealso{
Other data: 
\code{\link{hb_s_tau}()}
}
\concept{data}
